package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1PipelineViewResultBuilder extends V1alpha1PipelineViewResultFluentImpl<V1alpha1PipelineViewResultBuilder> implements VisitableBuilder<V1alpha1PipelineViewResult,V1alpha1PipelineViewResultBuilder>{

    V1alpha1PipelineViewResultFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1PipelineViewResultBuilder(){
            this(true);
    }
    public V1alpha1PipelineViewResultBuilder(Boolean validationEnabled){
            this(new V1alpha1PipelineViewResult(), validationEnabled);
    }
    public V1alpha1PipelineViewResultBuilder(V1alpha1PipelineViewResultFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1PipelineViewResultBuilder(V1alpha1PipelineViewResultFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1PipelineViewResult(), validationEnabled);
    }
    public V1alpha1PipelineViewResultBuilder(V1alpha1PipelineViewResultFluent<?> fluent,V1alpha1PipelineViewResult instance){
            this(fluent, instance, true);
    }
    public V1alpha1PipelineViewResultBuilder(V1alpha1PipelineViewResultFluent<?> fluent,V1alpha1PipelineViewResult instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion());

            fluent.withKind(instance.getKind());

            fluent.withMarkdown(instance.getMarkdown());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1PipelineViewResultBuilder(V1alpha1PipelineViewResult instance){
            this(instance,true);
    }
    public V1alpha1PipelineViewResultBuilder(V1alpha1PipelineViewResult instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion());

            this.withKind(instance.getKind());

            this.withMarkdown(instance.getMarkdown());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1PipelineViewResult build(){
            V1alpha1PipelineViewResult buildable = new V1alpha1PipelineViewResult();
            buildable.setApiVersion(fluent.getApiVersion());
            buildable.setKind(fluent.getKind());
            buildable.setMarkdown(fluent.getMarkdown());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1PipelineViewResultBuilder that = (V1alpha1PipelineViewResultBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
