package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1PipelineTriggerCodeChangeBuilder extends V1alpha1PipelineTriggerCodeChangeFluentImpl<V1alpha1PipelineTriggerCodeChangeBuilder> implements VisitableBuilder<V1alpha1PipelineTriggerCodeChange,V1alpha1PipelineTriggerCodeChangeBuilder>{

    V1alpha1PipelineTriggerCodeChangeFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1PipelineTriggerCodeChangeBuilder(){
            this(true);
    }
    public V1alpha1PipelineTriggerCodeChangeBuilder(Boolean validationEnabled){
            this(new V1alpha1PipelineTriggerCodeChange(), validationEnabled);
    }
    public V1alpha1PipelineTriggerCodeChangeBuilder(V1alpha1PipelineTriggerCodeChangeFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1PipelineTriggerCodeChangeBuilder(V1alpha1PipelineTriggerCodeChangeFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1PipelineTriggerCodeChange(), validationEnabled);
    }
    public V1alpha1PipelineTriggerCodeChangeBuilder(V1alpha1PipelineTriggerCodeChangeFluent<?> fluent,V1alpha1PipelineTriggerCodeChange instance){
            this(fluent, instance, true);
    }
    public V1alpha1PipelineTriggerCodeChangeBuilder(V1alpha1PipelineTriggerCodeChangeFluent<?> fluent,V1alpha1PipelineTriggerCodeChange instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withEnabled(instance.isEnabled());

            fluent.withPeriodicCheck(instance.getPeriodicCheck());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1PipelineTriggerCodeChangeBuilder(V1alpha1PipelineTriggerCodeChange instance){
            this(instance,true);
    }
    public V1alpha1PipelineTriggerCodeChangeBuilder(V1alpha1PipelineTriggerCodeChange instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withEnabled(instance.isEnabled());

            this.withPeriodicCheck(instance.getPeriodicCheck());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1PipelineTriggerCodeChange build(){
            V1alpha1PipelineTriggerCodeChange buildable = new V1alpha1PipelineTriggerCodeChange();
            buildable.setEnabled(fluent.isEnabled());
            buildable.setPeriodicCheck(fluent.getPeriodicCheck());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1PipelineTriggerCodeChangeBuilder that = (V1alpha1PipelineTriggerCodeChangeBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
