package io.alauda.devops.java.client.models;

import com.google.gson.annotations.SerializedName;
import io.alauda.devops.java.client.fluent.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.alauda.devops.java.client.fluent.BaseFluent;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public class V1alpha1PipelineTemplateWithValueFluentImpl<A extends V1alpha1PipelineTemplateWithValueFluent<A>> extends io.alauda.devops.java.client.fluent.BaseFluent<A> implements V1alpha1PipelineTemplateWithValueFluent<A>{

    private Map<String,List<V1alpha1KeyValue>> graphValues;
    private V1alpha1PipelineTemplateMoldBuilder pipelineTemplate;
    private V1alpha1PipelineTemplateRefBuilder pipelineTemplateRef;
    private Map<String,String> values;

    public V1alpha1PipelineTemplateWithValueFluentImpl(){
    }
    public V1alpha1PipelineTemplateWithValueFluentImpl(V1alpha1PipelineTemplateWithValue instance){
            this.withGraphValues(instance.getGraphValues());

            this.withPipelineTemplate(instance.getPipelineTemplate());

            this.withPipelineTemplateRef(instance.getPipelineTemplateRef());

            this.withValues(instance.getValues());

    }

    public A addToGraphValues(String key,List<V1alpha1KeyValue> value){
            if(this.graphValues == null && key != null && value != null) { this.graphValues = new LinkedHashMap<String,List<V1alpha1KeyValue>>(); }
            if(key != null && value != null) {this.graphValues.put(key, value);} return (A)this;
    }

    public A addToGraphValues(Map<String,List<V1alpha1KeyValue>> map){
            if(this.graphValues == null && map != null) { this.graphValues = new LinkedHashMap<String,List<V1alpha1KeyValue>>(); }
            if(map != null) { this.graphValues.putAll(map);} return (A)this;
    }

    public A removeFromGraphValues(String key){
            if(this.graphValues == null) { return (A) this; }
            if(key != null && this.graphValues != null) {this.graphValues.remove(key);} return (A)this;
    }

    public A removeFromGraphValues(Map<String,List<V1alpha1KeyValue>> map){
            if(this.graphValues == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.graphValues != null){this.graphValues.remove(key);}}} return (A)this;
    }

    public Map<String,List<V1alpha1KeyValue>> getGraphValues(){
            return this.graphValues;
    }

    public A withGraphValues(Map<String,List<V1alpha1KeyValue>> graphValues){
            if (graphValues == null) { this.graphValues =  null;} else {this.graphValues = new LinkedHashMap<String,List<V1alpha1KeyValue>>(graphValues);} return (A) this;
    }

    public Boolean hasGraphValues(){
            return this.graphValues != null;
    }

    
/**
 * This method has been deprecated, please use method buildPipelineTemplate instead.
 * @return The buildable object.
 */
@Deprecated public V1alpha1PipelineTemplateMold getPipelineTemplate(){
            return this.pipelineTemplate!=null?this.pipelineTemplate.build():null;
    }

    public V1alpha1PipelineTemplateMold buildPipelineTemplate(){
            return this.pipelineTemplate!=null?this.pipelineTemplate.build():null;
    }

    public A withPipelineTemplate(V1alpha1PipelineTemplateMold pipelineTemplate){
            _visitables.get("pipelineTemplate").remove(this.pipelineTemplate);
            if (pipelineTemplate!=null){ this.pipelineTemplate= new V1alpha1PipelineTemplateMoldBuilder(pipelineTemplate); _visitables.get("pipelineTemplate").add(this.pipelineTemplate);} return (A) this;
    }

    public Boolean hasPipelineTemplate(){
            return this.pipelineTemplate != null;
    }

    public V1alpha1PipelineTemplateWithValueFluent.PipelineTemplateNested<A> withNewPipelineTemplate(){
            return new PipelineTemplateNestedImpl();
    }

    public V1alpha1PipelineTemplateWithValueFluent.PipelineTemplateNested<A> withNewPipelineTemplateLike(V1alpha1PipelineTemplateMold item){
            return new PipelineTemplateNestedImpl(item);
    }

    public V1alpha1PipelineTemplateWithValueFluent.PipelineTemplateNested<A> editPipelineTemplate(){
            return withNewPipelineTemplateLike(getPipelineTemplate());
    }

    public V1alpha1PipelineTemplateWithValueFluent.PipelineTemplateNested<A> editOrNewPipelineTemplate(){
            return withNewPipelineTemplateLike(getPipelineTemplate() != null ? getPipelineTemplate(): new V1alpha1PipelineTemplateMoldBuilder().build());
    }

    public V1alpha1PipelineTemplateWithValueFluent.PipelineTemplateNested<A> editOrNewPipelineTemplateLike(V1alpha1PipelineTemplateMold item){
            return withNewPipelineTemplateLike(getPipelineTemplate() != null ? getPipelineTemplate(): item);
    }

    
/**
 * This method has been deprecated, please use method buildPipelineTemplateRef instead.
 * @return The buildable object.
 */
@Deprecated public V1alpha1PipelineTemplateRef getPipelineTemplateRef(){
            return this.pipelineTemplateRef!=null?this.pipelineTemplateRef.build():null;
    }

    public V1alpha1PipelineTemplateRef buildPipelineTemplateRef(){
            return this.pipelineTemplateRef!=null?this.pipelineTemplateRef.build():null;
    }

    public A withPipelineTemplateRef(V1alpha1PipelineTemplateRef pipelineTemplateRef){
            _visitables.get("pipelineTemplateRef").remove(this.pipelineTemplateRef);
            if (pipelineTemplateRef!=null){ this.pipelineTemplateRef= new V1alpha1PipelineTemplateRefBuilder(pipelineTemplateRef); _visitables.get("pipelineTemplateRef").add(this.pipelineTemplateRef);} return (A) this;
    }

    public Boolean hasPipelineTemplateRef(){
            return this.pipelineTemplateRef != null;
    }

    public V1alpha1PipelineTemplateWithValueFluent.PipelineTemplateRefNested<A> withNewPipelineTemplateRef(){
            return new PipelineTemplateRefNestedImpl();
    }

    public V1alpha1PipelineTemplateWithValueFluent.PipelineTemplateRefNested<A> withNewPipelineTemplateRefLike(V1alpha1PipelineTemplateRef item){
            return new PipelineTemplateRefNestedImpl(item);
    }

    public V1alpha1PipelineTemplateWithValueFluent.PipelineTemplateRefNested<A> editPipelineTemplateRef(){
            return withNewPipelineTemplateRefLike(getPipelineTemplateRef());
    }

    public V1alpha1PipelineTemplateWithValueFluent.PipelineTemplateRefNested<A> editOrNewPipelineTemplateRef(){
            return withNewPipelineTemplateRefLike(getPipelineTemplateRef() != null ? getPipelineTemplateRef(): new V1alpha1PipelineTemplateRefBuilder().build());
    }

    public V1alpha1PipelineTemplateWithValueFluent.PipelineTemplateRefNested<A> editOrNewPipelineTemplateRefLike(V1alpha1PipelineTemplateRef item){
            return withNewPipelineTemplateRefLike(getPipelineTemplateRef() != null ? getPipelineTemplateRef(): item);
    }

    public A addToValues(String key,String value){
            if(this.values == null && key != null && value != null) { this.values = new LinkedHashMap<String,String>(); }
            if(key != null && value != null) {this.values.put(key, value);} return (A)this;
    }

    public A addToValues(Map<String,String> map){
            if(this.values == null && map != null) { this.values = new LinkedHashMap<String,String>(); }
            if(map != null) { this.values.putAll(map);} return (A)this;
    }

    public A removeFromValues(String key){
            if(this.values == null) { return (A) this; }
            if(key != null && this.values != null) {this.values.remove(key);} return (A)this;
    }

    public A removeFromValues(Map<String,String> map){
            if(this.values == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.values != null){this.values.remove(key);}}} return (A)this;
    }

    public Map<String,String> getValues(){
            return this.values;
    }

    public A withValues(Map<String,String> values){
            if (values == null) { this.values =  null;} else {this.values = new LinkedHashMap<String,String>(values);} return (A) this;
    }

    public Boolean hasValues(){
            return this.values != null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1PipelineTemplateWithValueFluentImpl that = (V1alpha1PipelineTemplateWithValueFluentImpl) o;
            if (graphValues != null ? !graphValues.equals(that.graphValues) :that.graphValues != null) return false;
            if (pipelineTemplate != null ? !pipelineTemplate.equals(that.pipelineTemplate) :that.pipelineTemplate != null) return false;
            if (pipelineTemplateRef != null ? !pipelineTemplateRef.equals(that.pipelineTemplateRef) :that.pipelineTemplateRef != null) return false;
            if (values != null ? !values.equals(that.values) :that.values != null) return false;
            return true;
    }


    public class PipelineTemplateNestedImpl<N> extends V1alpha1PipelineTemplateMoldFluentImpl<V1alpha1PipelineTemplateWithValueFluent.PipelineTemplateNested<N>> implements V1alpha1PipelineTemplateWithValueFluent.PipelineTemplateNested<N>,io.alauda.devops.java.client.fluent.Nested<N>{

            private final V1alpha1PipelineTemplateMoldBuilder builder;
    
            PipelineTemplateNestedImpl(V1alpha1PipelineTemplateMold item){
                    this.builder = new V1alpha1PipelineTemplateMoldBuilder(this, item);
            }
            PipelineTemplateNestedImpl(){
                    this.builder = new V1alpha1PipelineTemplateMoldBuilder(this);
            }
    
    public N and(){
            return (N) V1alpha1PipelineTemplateWithValueFluentImpl.this.withPipelineTemplate(builder.build());
    }
    public N endPipelineTemplate(){
            return and();
    }

}
    public class PipelineTemplateRefNestedImpl<N> extends V1alpha1PipelineTemplateRefFluentImpl<V1alpha1PipelineTemplateWithValueFluent.PipelineTemplateRefNested<N>> implements V1alpha1PipelineTemplateWithValueFluent.PipelineTemplateRefNested<N>,io.alauda.devops.java.client.fluent.Nested<N>{

            private final V1alpha1PipelineTemplateRefBuilder builder;
    
            PipelineTemplateRefNestedImpl(V1alpha1PipelineTemplateRef item){
                    this.builder = new V1alpha1PipelineTemplateRefBuilder(this, item);
            }
            PipelineTemplateRefNestedImpl(){
                    this.builder = new V1alpha1PipelineTemplateRefBuilder(this);
            }
    
    public N and(){
            return (N) V1alpha1PipelineTemplateWithValueFluentImpl.this.withPipelineTemplateRef(builder.build());
    }
    public N endPipelineTemplateRef(){
            return and();
    }

}


}
