package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1PipelineTemplateWithValueBuilder extends V1alpha1PipelineTemplateWithValueFluentImpl<V1alpha1PipelineTemplateWithValueBuilder> implements VisitableBuilder<V1alpha1PipelineTemplateWithValue,V1alpha1PipelineTemplateWithValueBuilder>{

    V1alpha1PipelineTemplateWithValueFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1PipelineTemplateWithValueBuilder(){
            this(true);
    }
    public V1alpha1PipelineTemplateWithValueBuilder(Boolean validationEnabled){
            this(new V1alpha1PipelineTemplateWithValue(), validationEnabled);
    }
    public V1alpha1PipelineTemplateWithValueBuilder(V1alpha1PipelineTemplateWithValueFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1PipelineTemplateWithValueBuilder(V1alpha1PipelineTemplateWithValueFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1PipelineTemplateWithValue(), validationEnabled);
    }
    public V1alpha1PipelineTemplateWithValueBuilder(V1alpha1PipelineTemplateWithValueFluent<?> fluent,V1alpha1PipelineTemplateWithValue instance){
            this(fluent, instance, true);
    }
    public V1alpha1PipelineTemplateWithValueBuilder(V1alpha1PipelineTemplateWithValueFluent<?> fluent,V1alpha1PipelineTemplateWithValue instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withGraphValues(instance.getGraphValues());

            fluent.withPipelineTemplate(instance.getPipelineTemplate());

            fluent.withPipelineTemplateRef(instance.getPipelineTemplateRef());

            fluent.withValues(instance.getValues());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1PipelineTemplateWithValueBuilder(V1alpha1PipelineTemplateWithValue instance){
            this(instance,true);
    }
    public V1alpha1PipelineTemplateWithValueBuilder(V1alpha1PipelineTemplateWithValue instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withGraphValues(instance.getGraphValues());

            this.withPipelineTemplate(instance.getPipelineTemplate());

            this.withPipelineTemplateRef(instance.getPipelineTemplateRef());

            this.withValues(instance.getValues());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1PipelineTemplateWithValue build(){
            V1alpha1PipelineTemplateWithValue buildable = new V1alpha1PipelineTemplateWithValue();
            buildable.setGraphValues(fluent.getGraphValues());
            buildable.setPipelineTemplate(fluent.getPipelineTemplate());
            buildable.setPipelineTemplateRef(fluent.getPipelineTemplateRef());
            buildable.setValues(fluent.getValues());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1PipelineTemplateWithValueBuilder that = (V1alpha1PipelineTemplateWithValueBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
