package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1PipelineTemplateRefBuilder extends V1alpha1PipelineTemplateRefFluentImpl<V1alpha1PipelineTemplateRefBuilder> implements VisitableBuilder<V1alpha1PipelineTemplateRef,V1alpha1PipelineTemplateRefBuilder>{

    V1alpha1PipelineTemplateRefFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1PipelineTemplateRefBuilder(){
            this(true);
    }
    public V1alpha1PipelineTemplateRefBuilder(Boolean validationEnabled){
            this(new V1alpha1PipelineTemplateRef(), validationEnabled);
    }
    public V1alpha1PipelineTemplateRefBuilder(V1alpha1PipelineTemplateRefFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1PipelineTemplateRefBuilder(V1alpha1PipelineTemplateRefFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1PipelineTemplateRef(), validationEnabled);
    }
    public V1alpha1PipelineTemplateRefBuilder(V1alpha1PipelineTemplateRefFluent<?> fluent,V1alpha1PipelineTemplateRef instance){
            this(fluent, instance, true);
    }
    public V1alpha1PipelineTemplateRefBuilder(V1alpha1PipelineTemplateRefFluent<?> fluent,V1alpha1PipelineTemplateRef instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withKind(instance.getKind());

            fluent.withName(instance.getName());

            fluent.withNamespace(instance.getNamespace());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1PipelineTemplateRefBuilder(V1alpha1PipelineTemplateRef instance){
            this(instance,true);
    }
    public V1alpha1PipelineTemplateRefBuilder(V1alpha1PipelineTemplateRef instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withKind(instance.getKind());

            this.withName(instance.getName());

            this.withNamespace(instance.getNamespace());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1PipelineTemplateRef build(){
            V1alpha1PipelineTemplateRef buildable = new V1alpha1PipelineTemplateRef();
            buildable.setKind(fluent.getKind());
            buildable.setName(fluent.getName());
            buildable.setNamespace(fluent.getNamespace());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1PipelineTemplateRefBuilder that = (V1alpha1PipelineTemplateRefBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
