package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1PipelineTaskBuilder extends V1alpha1PipelineTaskFluentImpl<V1alpha1PipelineTaskBuilder> implements VisitableBuilder<V1alpha1PipelineTask,V1alpha1PipelineTaskBuilder>{

    V1alpha1PipelineTaskFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1PipelineTaskBuilder(){
            this(true);
    }
    public V1alpha1PipelineTaskBuilder(Boolean validationEnabled){
            this(new V1alpha1PipelineTask(), validationEnabled);
    }
    public V1alpha1PipelineTaskBuilder(V1alpha1PipelineTaskFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1PipelineTaskBuilder(V1alpha1PipelineTaskFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1PipelineTask(), validationEnabled);
    }
    public V1alpha1PipelineTaskBuilder(V1alpha1PipelineTaskFluent<?> fluent,V1alpha1PipelineTask instance){
            this(fluent, instance, true);
    }
    public V1alpha1PipelineTaskBuilder(V1alpha1PipelineTaskFluent<?> fluent,V1alpha1PipelineTask instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion());

            fluent.withKind(instance.getKind());

            fluent.withTasks(instance.getTasks());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1PipelineTaskBuilder(V1alpha1PipelineTask instance){
            this(instance,true);
    }
    public V1alpha1PipelineTaskBuilder(V1alpha1PipelineTask instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion());

            this.withKind(instance.getKind());

            this.withTasks(instance.getTasks());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1PipelineTask build(){
            V1alpha1PipelineTask buildable = new V1alpha1PipelineTask();
            buildable.setApiVersion(fluent.getApiVersion());
            buildable.setKind(fluent.getKind());
            buildable.setTasks(fluent.getTasks());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1PipelineTaskBuilder that = (V1alpha1PipelineTaskBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
