package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1PipelineStrategyBuilder extends V1alpha1PipelineStrategyFluentImpl<V1alpha1PipelineStrategyBuilder> implements VisitableBuilder<V1alpha1PipelineStrategy,V1alpha1PipelineStrategyBuilder>{

    V1alpha1PipelineStrategyFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1PipelineStrategyBuilder(){
            this(true);
    }
    public V1alpha1PipelineStrategyBuilder(Boolean validationEnabled){
            this(new V1alpha1PipelineStrategy(), validationEnabled);
    }
    public V1alpha1PipelineStrategyBuilder(V1alpha1PipelineStrategyFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1PipelineStrategyBuilder(V1alpha1PipelineStrategyFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1PipelineStrategy(), validationEnabled);
    }
    public V1alpha1PipelineStrategyBuilder(V1alpha1PipelineStrategyFluent<?> fluent,V1alpha1PipelineStrategy instance){
            this(fluent, instance, true);
    }
    public V1alpha1PipelineStrategyBuilder(V1alpha1PipelineStrategyFluent<?> fluent,V1alpha1PipelineStrategy instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withJenkins(instance.getJenkins());

            fluent.withTemplate(instance.getTemplate());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1PipelineStrategyBuilder(V1alpha1PipelineStrategy instance){
            this(instance,true);
    }
    public V1alpha1PipelineStrategyBuilder(V1alpha1PipelineStrategy instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withJenkins(instance.getJenkins());

            this.withTemplate(instance.getTemplate());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1PipelineStrategy build(){
            V1alpha1PipelineStrategy buildable = new V1alpha1PipelineStrategy();
            buildable.setJenkins(fluent.getJenkins());
            buildable.setTemplate(fluent.getTemplate());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1PipelineStrategyBuilder that = (V1alpha1PipelineStrategyBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
