package io.alauda.devops.java.client.models;

import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.alauda.devops.java.client.fluent.Nested;
import java.util.ArrayList;
import java.lang.String;
import org.joda.time.DateTime;
import io.alauda.devops.java.client.fluent.Predicate;
import java.lang.Deprecated;
import io.alauda.devops.java.client.fluent.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;

public class V1alpha1PipelineStatusFluentImpl<A extends V1alpha1PipelineStatusFluent<A>> extends io.alauda.devops.java.client.fluent.BaseFluent<A> implements V1alpha1PipelineStatusFluent<A>{

    private Boolean aborted;
    private List<V1alpha1ConditionBuilder> conditions;
    private DateTime finishedAt;
    private V1alpha1PipelineStatusInfoBuilder information;
    private V1alpha1PipelineStatusJenkinsBuilder jenkins;
    private String phase;
    private DateTime startedAt;
    private DateTime updatedAt;

    public V1alpha1PipelineStatusFluentImpl(){
    }
    public V1alpha1PipelineStatusFluentImpl(V1alpha1PipelineStatus instance){
            this.withAborted(instance.isAborted());

            this.withConditions(instance.getConditions());

            this.withFinishedAt(instance.getFinishedAt());

            this.withInformation(instance.getInformation());

            this.withJenkins(instance.getJenkins());

            this.withPhase(instance.getPhase());

            this.withStartedAt(instance.getStartedAt());

            this.withUpdatedAt(instance.getUpdatedAt());

    }

    public Boolean isAborted(){
            return this.aborted;
    }

    public A withAborted(Boolean aborted){
            this.aborted=aborted; return (A) this;
    }

    public Boolean hasAborted(){
            return this.aborted != null;
    }

    public A withNewAborted(String arg1){
            return (A)withAborted(new Boolean(arg1));
    }

    public A withNewAborted(boolean arg1){
            return (A)withAborted(new Boolean(arg1));
    }

    public A addToConditions(int index,V1alpha1Condition item){
            if (this.conditions == null) {this.conditions = new ArrayList<V1alpha1ConditionBuilder>();}
            V1alpha1ConditionBuilder builder = new V1alpha1ConditionBuilder(item);_visitables.get("conditions").add(index >= 0 ? index : _visitables.get("conditions").size(), builder);this.conditions.add(index >= 0 ? index : conditions.size(), builder); return (A)this;
    }

    public A setToConditions(int index,V1alpha1Condition item){
            if (this.conditions == null) {this.conditions = new ArrayList<V1alpha1ConditionBuilder>();}
            V1alpha1ConditionBuilder builder = new V1alpha1ConditionBuilder(item);
            if (index < 0 || index >= _visitables.get("conditions").size()) { _visitables.get("conditions").add(builder); } else { _visitables.get("conditions").set(index, builder);}
            if (index < 0 || index >= conditions.size()) { conditions.add(builder); } else { conditions.set(index, builder);}
             return (A)this;
    }

    public A addToConditions(V1alpha1Condition... items){
            if (this.conditions == null) {this.conditions = new ArrayList<V1alpha1ConditionBuilder>();}
            for (V1alpha1Condition item : items) {V1alpha1ConditionBuilder builder = new V1alpha1ConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A addAllToConditions(Collection<V1alpha1Condition> items){
            if (this.conditions == null) {this.conditions = new ArrayList<V1alpha1ConditionBuilder>();}
            for (V1alpha1Condition item : items) {V1alpha1ConditionBuilder builder = new V1alpha1ConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A removeFromConditions(V1alpha1Condition... items){
            for (V1alpha1Condition item : items) {V1alpha1ConditionBuilder builder = new V1alpha1ConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    public A removeAllFromConditions(Collection<V1alpha1Condition> items){
            for (V1alpha1Condition item : items) {V1alpha1ConditionBuilder builder = new V1alpha1ConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildConditions instead.
 * @return The buildable object.
 */
@Deprecated public List<V1alpha1Condition> getConditions(){
            return build(conditions);
    }

    public List<V1alpha1Condition> buildConditions(){
            return build(conditions);
    }

    public V1alpha1Condition buildCondition(int index){
            return this.conditions.get(index).build();
    }

    public V1alpha1Condition buildFirstCondition(){
            return this.conditions.get(0).build();
    }

    public V1alpha1Condition buildLastCondition(){
            return this.conditions.get(conditions.size() - 1).build();
    }

    public V1alpha1Condition buildMatchingCondition(io.alauda.devops.java.client.fluent.Predicate<V1alpha1ConditionBuilder> predicate){
            for (V1alpha1ConditionBuilder item: conditions) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public Boolean hasMatchingCondition(io.alauda.devops.java.client.fluent.Predicate<V1alpha1ConditionBuilder> predicate){
            for (V1alpha1ConditionBuilder item: conditions) { if(predicate.apply(item)){return true;} } return false;
    }

    public A withConditions(List<V1alpha1Condition> conditions){
            if (this.conditions != null) { _visitables.get("conditions").removeAll(this.conditions);}
            if (conditions != null) {this.conditions = new ArrayList<V1alpha1ConditionBuilder>(); for (V1alpha1Condition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
    }

    public A withConditions(V1alpha1Condition... conditions){
            if (this.conditions != null) {this.conditions.clear();}
            if (conditions != null) {for (V1alpha1Condition item :conditions){ this.addToConditions(item);}} return (A) this;
    }

    public Boolean hasConditions(){
            return conditions != null && !conditions.isEmpty();
    }

    public V1alpha1PipelineStatusFluent.ConditionsNested<A> addNewCondition(){
            return new ConditionsNestedImpl();
    }

    public V1alpha1PipelineStatusFluent.ConditionsNested<A> addNewConditionLike(V1alpha1Condition item){
            return new ConditionsNestedImpl(-1, item);
    }

    public V1alpha1PipelineStatusFluent.ConditionsNested<A> setNewConditionLike(int index,V1alpha1Condition item){
            return new ConditionsNestedImpl(index, item);
    }

    public V1alpha1PipelineStatusFluent.ConditionsNested<A> editCondition(int index){
            if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
            return setNewConditionLike(index, buildCondition(index));
    }

    public V1alpha1PipelineStatusFluent.ConditionsNested<A> editFirstCondition(){
            if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
            return setNewConditionLike(0, buildCondition(0));
    }

    public V1alpha1PipelineStatusFluent.ConditionsNested<A> editLastCondition(){
            int index = conditions.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
            return setNewConditionLike(index, buildCondition(index));
    }

    public V1alpha1PipelineStatusFluent.ConditionsNested<A> editMatchingCondition(io.alauda.devops.java.client.fluent.Predicate<V1alpha1ConditionBuilder> predicate){
            int index = -1;
            for (int i=0;i<conditions.size();i++) { 
            if (predicate.apply(conditions.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
            return setNewConditionLike(index, buildCondition(index));
    }

    public DateTime getFinishedAt(){
            return this.finishedAt;
    }

    public A withFinishedAt(DateTime finishedAt){
            this.finishedAt=finishedAt; return (A) this;
    }

    public Boolean hasFinishedAt(){
            return this.finishedAt != null;
    }

    public A withNewFinishedAt(int arg0,int arg1,int arg2,int arg3,int arg4){
            return (A)withFinishedAt(new DateTime(arg0, arg1, arg2, arg3, arg4));
    }

    public A withNewFinishedAt(Object arg0){
            return (A)withFinishedAt(new DateTime(arg0));
    }

    public A withNewFinishedAt(long arg0){
            return (A)withFinishedAt(new DateTime(arg0));
    }

    
/**
 * This method has been deprecated, please use method buildInformation instead.
 * @return The buildable object.
 */
@Deprecated public V1alpha1PipelineStatusInfo getInformation(){
            return this.information!=null?this.information.build():null;
    }

    public V1alpha1PipelineStatusInfo buildInformation(){
            return this.information!=null?this.information.build():null;
    }

    public A withInformation(V1alpha1PipelineStatusInfo information){
            _visitables.get("information").remove(this.information);
            if (information!=null){ this.information= new V1alpha1PipelineStatusInfoBuilder(information); _visitables.get("information").add(this.information);} return (A) this;
    }

    public Boolean hasInformation(){
            return this.information != null;
    }

    public V1alpha1PipelineStatusFluent.InformationNested<A> withNewInformation(){
            return new InformationNestedImpl();
    }

    public V1alpha1PipelineStatusFluent.InformationNested<A> withNewInformationLike(V1alpha1PipelineStatusInfo item){
            return new InformationNestedImpl(item);
    }

    public V1alpha1PipelineStatusFluent.InformationNested<A> editInformation(){
            return withNewInformationLike(getInformation());
    }

    public V1alpha1PipelineStatusFluent.InformationNested<A> editOrNewInformation(){
            return withNewInformationLike(getInformation() != null ? getInformation(): new V1alpha1PipelineStatusInfoBuilder().build());
    }

    public V1alpha1PipelineStatusFluent.InformationNested<A> editOrNewInformationLike(V1alpha1PipelineStatusInfo item){
            return withNewInformationLike(getInformation() != null ? getInformation(): item);
    }

    
/**
 * This method has been deprecated, please use method buildJenkins instead.
 * @return The buildable object.
 */
@Deprecated public V1alpha1PipelineStatusJenkins getJenkins(){
            return this.jenkins!=null?this.jenkins.build():null;
    }

    public V1alpha1PipelineStatusJenkins buildJenkins(){
            return this.jenkins!=null?this.jenkins.build():null;
    }

    public A withJenkins(V1alpha1PipelineStatusJenkins jenkins){
            _visitables.get("jenkins").remove(this.jenkins);
            if (jenkins!=null){ this.jenkins= new V1alpha1PipelineStatusJenkinsBuilder(jenkins); _visitables.get("jenkins").add(this.jenkins);} return (A) this;
    }

    public Boolean hasJenkins(){
            return this.jenkins != null;
    }

    public V1alpha1PipelineStatusFluent.JenkinsNested<A> withNewJenkins(){
            return new JenkinsNestedImpl();
    }

    public V1alpha1PipelineStatusFluent.JenkinsNested<A> withNewJenkinsLike(V1alpha1PipelineStatusJenkins item){
            return new JenkinsNestedImpl(item);
    }

    public V1alpha1PipelineStatusFluent.JenkinsNested<A> editJenkins(){
            return withNewJenkinsLike(getJenkins());
    }

    public V1alpha1PipelineStatusFluent.JenkinsNested<A> editOrNewJenkins(){
            return withNewJenkinsLike(getJenkins() != null ? getJenkins(): new V1alpha1PipelineStatusJenkinsBuilder().build());
    }

    public V1alpha1PipelineStatusFluent.JenkinsNested<A> editOrNewJenkinsLike(V1alpha1PipelineStatusJenkins item){
            return withNewJenkinsLike(getJenkins() != null ? getJenkins(): item);
    }

    public String getPhase(){
            return this.phase;
    }

    public A withPhase(String phase){
            this.phase=phase; return (A) this;
    }

    public Boolean hasPhase(){
            return this.phase != null;
    }

    public A withNewPhase(String arg1){
            return (A)withPhase(new String(arg1));
    }

    public A withNewPhase(StringBuilder arg1){
            return (A)withPhase(new String(arg1));
    }

    public A withNewPhase(StringBuffer arg1){
            return (A)withPhase(new String(arg1));
    }

    public DateTime getStartedAt(){
            return this.startedAt;
    }

    public A withStartedAt(DateTime startedAt){
            this.startedAt=startedAt; return (A) this;
    }

    public Boolean hasStartedAt(){
            return this.startedAt != null;
    }

    public A withNewStartedAt(int arg0,int arg1,int arg2,int arg3,int arg4){
            return (A)withStartedAt(new DateTime(arg0, arg1, arg2, arg3, arg4));
    }

    public A withNewStartedAt(Object arg0){
            return (A)withStartedAt(new DateTime(arg0));
    }

    public A withNewStartedAt(long arg0){
            return (A)withStartedAt(new DateTime(arg0));
    }

    public DateTime getUpdatedAt(){
            return this.updatedAt;
    }

    public A withUpdatedAt(DateTime updatedAt){
            this.updatedAt=updatedAt; return (A) this;
    }

    public Boolean hasUpdatedAt(){
            return this.updatedAt != null;
    }

    public A withNewUpdatedAt(int arg0,int arg1,int arg2,int arg3,int arg4){
            return (A)withUpdatedAt(new DateTime(arg0, arg1, arg2, arg3, arg4));
    }

    public A withNewUpdatedAt(Object arg0){
            return (A)withUpdatedAt(new DateTime(arg0));
    }

    public A withNewUpdatedAt(long arg0){
            return (A)withUpdatedAt(new DateTime(arg0));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1PipelineStatusFluentImpl that = (V1alpha1PipelineStatusFluentImpl) o;
            if (aborted != null ? !aborted.equals(that.aborted) :that.aborted != null) return false;
            if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
            if (finishedAt != null ? !finishedAt.equals(that.finishedAt) :that.finishedAt != null) return false;
            if (information != null ? !information.equals(that.information) :that.information != null) return false;
            if (jenkins != null ? !jenkins.equals(that.jenkins) :that.jenkins != null) return false;
            if (phase != null ? !phase.equals(that.phase) :that.phase != null) return false;
            if (startedAt != null ? !startedAt.equals(that.startedAt) :that.startedAt != null) return false;
            if (updatedAt != null ? !updatedAt.equals(that.updatedAt) :that.updatedAt != null) return false;
            return true;
    }


    public class ConditionsNestedImpl<N> extends V1alpha1ConditionFluentImpl<V1alpha1PipelineStatusFluent.ConditionsNested<N>> implements V1alpha1PipelineStatusFluent.ConditionsNested<N>,io.alauda.devops.java.client.fluent.Nested<N>{

            private final V1alpha1ConditionBuilder builder;
        private final int index;
    
            ConditionsNestedImpl(int index,V1alpha1Condition item){
                    this.index = index;
                    this.builder = new V1alpha1ConditionBuilder(this, item);
            }
            ConditionsNestedImpl(){
                    this.index = -1;
                    this.builder = new V1alpha1ConditionBuilder(this);
            }
    
    public N and(){
            return (N) V1alpha1PipelineStatusFluentImpl.this.setToConditions(index, builder.build());
    }
    public N endCondition(){
            return and();
    }

}
    public class InformationNestedImpl<N> extends V1alpha1PipelineStatusInfoFluentImpl<V1alpha1PipelineStatusFluent.InformationNested<N>> implements V1alpha1PipelineStatusFluent.InformationNested<N>,io.alauda.devops.java.client.fluent.Nested<N>{

            private final V1alpha1PipelineStatusInfoBuilder builder;
    
            InformationNestedImpl(V1alpha1PipelineStatusInfo item){
                    this.builder = new V1alpha1PipelineStatusInfoBuilder(this, item);
            }
            InformationNestedImpl(){
                    this.builder = new V1alpha1PipelineStatusInfoBuilder(this);
            }
    
    public N and(){
            return (N) V1alpha1PipelineStatusFluentImpl.this.withInformation(builder.build());
    }
    public N endInformation(){
            return and();
    }

}
    public class JenkinsNestedImpl<N> extends V1alpha1PipelineStatusJenkinsFluentImpl<V1alpha1PipelineStatusFluent.JenkinsNested<N>> implements V1alpha1PipelineStatusFluent.JenkinsNested<N>,io.alauda.devops.java.client.fluent.Nested<N>{

            private final V1alpha1PipelineStatusJenkinsBuilder builder;
    
            JenkinsNestedImpl(V1alpha1PipelineStatusJenkins item){
                    this.builder = new V1alpha1PipelineStatusJenkinsBuilder(this, item);
            }
            JenkinsNestedImpl(){
                    this.builder = new V1alpha1PipelineStatusJenkinsBuilder(this);
            }
    
    public N and(){
            return (N) V1alpha1PipelineStatusFluentImpl.this.withJenkins(builder.build());
    }
    public N endJenkins(){
            return and();
    }

}


}
