package io.alauda.devops.java.client.models;

import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.lang.String;
import io.alauda.devops.java.client.fluent.Predicate;
import io.alauda.devops.java.client.fluent.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import java.util.Collection;
import java.lang.Object;
import java.lang.StringBuilder;
import io.alauda.devops.java.client.fluent.Nested;
import java.lang.Deprecated;
import java.lang.StringBuffer;

public class V1alpha1PipelineSpecFluentImpl<A extends V1alpha1PipelineSpecFluent<A>> extends io.alauda.devops.java.client.fluent.BaseFluent<A> implements V1alpha1PipelineSpecFluent<A>{

    private Boolean cancel;
    private V1alpha1PipelineCauseBuilder cause;
    private List<V1alpha1PipelineHookBuilder> hooks;
    private V1alpha1LocalObjectReferenceBuilder jenkinsBinding;
    private List<V1alpha1PipelineParameterBuilder> parameters;
    private V1alpha1LocalObjectReferenceBuilder pipelineConfig;
    private String runPolicy;
    private V1alpha1PipelineSourceBuilder source;
    private V1alpha1PipelineStrategyBuilder strategy;
    private List<V1alpha1PipelineTriggerBuilder> triggers;

    public V1alpha1PipelineSpecFluentImpl(){
    }
    public V1alpha1PipelineSpecFluentImpl(V1alpha1PipelineSpec instance){
            this.withCancel(instance.isCancel());

            this.withCause(instance.getCause());

            this.withHooks(instance.getHooks());

            this.withJenkinsBinding(instance.getJenkinsBinding());

            this.withParameters(instance.getParameters());

            this.withPipelineConfig(instance.getPipelineConfig());

            this.withRunPolicy(instance.getRunPolicy());

            this.withSource(instance.getSource());

            this.withStrategy(instance.getStrategy());

            this.withTriggers(instance.getTriggers());

    }

    public Boolean isCancel(){
            return this.cancel;
    }

    public A withCancel(Boolean cancel){
            this.cancel=cancel; return (A) this;
    }

    public Boolean hasCancel(){
            return this.cancel != null;
    }

    public A withNewCancel(String arg1){
            return (A)withCancel(new Boolean(arg1));
    }

    public A withNewCancel(boolean arg1){
            return (A)withCancel(new Boolean(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildCause instead.
 * @return The buildable object.
 */
@Deprecated public V1alpha1PipelineCause getCause(){
            return this.cause!=null?this.cause.build():null;
    }

    public V1alpha1PipelineCause buildCause(){
            return this.cause!=null?this.cause.build():null;
    }

    public A withCause(V1alpha1PipelineCause cause){
            _visitables.get("cause").remove(this.cause);
            if (cause!=null){ this.cause= new V1alpha1PipelineCauseBuilder(cause); _visitables.get("cause").add(this.cause);} return (A) this;
    }

    public Boolean hasCause(){
            return this.cause != null;
    }

    public V1alpha1PipelineSpecFluent.CauseNested<A> withNewCause(){
            return new CauseNestedImpl();
    }

    public V1alpha1PipelineSpecFluent.CauseNested<A> withNewCauseLike(V1alpha1PipelineCause item){
            return new CauseNestedImpl(item);
    }

    public V1alpha1PipelineSpecFluent.CauseNested<A> editCause(){
            return withNewCauseLike(getCause());
    }

    public V1alpha1PipelineSpecFluent.CauseNested<A> editOrNewCause(){
            return withNewCauseLike(getCause() != null ? getCause(): new V1alpha1PipelineCauseBuilder().build());
    }

    public V1alpha1PipelineSpecFluent.CauseNested<A> editOrNewCauseLike(V1alpha1PipelineCause item){
            return withNewCauseLike(getCause() != null ? getCause(): item);
    }

    public A addToHooks(int index,V1alpha1PipelineHook item){
            if (this.hooks == null) {this.hooks = new ArrayList<V1alpha1PipelineHookBuilder>();}
            V1alpha1PipelineHookBuilder builder = new V1alpha1PipelineHookBuilder(item);_visitables.get("hooks").add(index >= 0 ? index : _visitables.get("hooks").size(), builder);this.hooks.add(index >= 0 ? index : hooks.size(), builder); return (A)this;
    }

    public A setToHooks(int index,V1alpha1PipelineHook item){
            if (this.hooks == null) {this.hooks = new ArrayList<V1alpha1PipelineHookBuilder>();}
            V1alpha1PipelineHookBuilder builder = new V1alpha1PipelineHookBuilder(item);
            if (index < 0 || index >= _visitables.get("hooks").size()) { _visitables.get("hooks").add(builder); } else { _visitables.get("hooks").set(index, builder);}
            if (index < 0 || index >= hooks.size()) { hooks.add(builder); } else { hooks.set(index, builder);}
             return (A)this;
    }

    public A addToHooks(V1alpha1PipelineHook... items){
            if (this.hooks == null) {this.hooks = new ArrayList<V1alpha1PipelineHookBuilder>();}
            for (V1alpha1PipelineHook item : items) {V1alpha1PipelineHookBuilder builder = new V1alpha1PipelineHookBuilder(item);_visitables.get("hooks").add(builder);this.hooks.add(builder);} return (A)this;
    }

    public A addAllToHooks(Collection<V1alpha1PipelineHook> items){
            if (this.hooks == null) {this.hooks = new ArrayList<V1alpha1PipelineHookBuilder>();}
            for (V1alpha1PipelineHook item : items) {V1alpha1PipelineHookBuilder builder = new V1alpha1PipelineHookBuilder(item);_visitables.get("hooks").add(builder);this.hooks.add(builder);} return (A)this;
    }

    public A removeFromHooks(V1alpha1PipelineHook... items){
            for (V1alpha1PipelineHook item : items) {V1alpha1PipelineHookBuilder builder = new V1alpha1PipelineHookBuilder(item);_visitables.get("hooks").remove(builder);if (this.hooks != null) {this.hooks.remove(builder);}} return (A)this;
    }

    public A removeAllFromHooks(Collection<V1alpha1PipelineHook> items){
            for (V1alpha1PipelineHook item : items) {V1alpha1PipelineHookBuilder builder = new V1alpha1PipelineHookBuilder(item);_visitables.get("hooks").remove(builder);if (this.hooks != null) {this.hooks.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildHooks instead.
 * @return The buildable object.
 */
@Deprecated public List<V1alpha1PipelineHook> getHooks(){
            return build(hooks);
    }

    public List<V1alpha1PipelineHook> buildHooks(){
            return build(hooks);
    }

    public V1alpha1PipelineHook buildHook(int index){
            return this.hooks.get(index).build();
    }

    public V1alpha1PipelineHook buildFirstHook(){
            return this.hooks.get(0).build();
    }

    public V1alpha1PipelineHook buildLastHook(){
            return this.hooks.get(hooks.size() - 1).build();
    }

    public V1alpha1PipelineHook buildMatchingHook(io.alauda.devops.java.client.fluent.Predicate<V1alpha1PipelineHookBuilder> predicate){
            for (V1alpha1PipelineHookBuilder item: hooks) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public Boolean hasMatchingHook(io.alauda.devops.java.client.fluent.Predicate<V1alpha1PipelineHookBuilder> predicate){
            for (V1alpha1PipelineHookBuilder item: hooks) { if(predicate.apply(item)){return true;} } return false;
    }

    public A withHooks(List<V1alpha1PipelineHook> hooks){
            if (this.hooks != null) { _visitables.get("hooks").removeAll(this.hooks);}
            if (hooks != null) {this.hooks = new ArrayList<V1alpha1PipelineHookBuilder>(); for (V1alpha1PipelineHook item : hooks){this.addToHooks(item);}} else { this.hooks = null;} return (A) this;
    }

    public A withHooks(V1alpha1PipelineHook... hooks){
            if (this.hooks != null) {this.hooks.clear();}
            if (hooks != null) {for (V1alpha1PipelineHook item :hooks){ this.addToHooks(item);}} return (A) this;
    }

    public Boolean hasHooks(){
            return hooks != null && !hooks.isEmpty();
    }

    public V1alpha1PipelineSpecFluent.HooksNested<A> addNewHook(){
            return new HooksNestedImpl();
    }

    public V1alpha1PipelineSpecFluent.HooksNested<A> addNewHookLike(V1alpha1PipelineHook item){
            return new HooksNestedImpl(-1, item);
    }

    public V1alpha1PipelineSpecFluent.HooksNested<A> setNewHookLike(int index,V1alpha1PipelineHook item){
            return new HooksNestedImpl(index, item);
    }

    public V1alpha1PipelineSpecFluent.HooksNested<A> editHook(int index){
            if (hooks.size() <= index) throw new RuntimeException("Can't edit hooks. Index exceeds size.");
            return setNewHookLike(index, buildHook(index));
    }

    public V1alpha1PipelineSpecFluent.HooksNested<A> editFirstHook(){
            if (hooks.size() == 0) throw new RuntimeException("Can't edit first hooks. The list is empty.");
            return setNewHookLike(0, buildHook(0));
    }

    public V1alpha1PipelineSpecFluent.HooksNested<A> editLastHook(){
            int index = hooks.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last hooks. The list is empty.");
            return setNewHookLike(index, buildHook(index));
    }

    public V1alpha1PipelineSpecFluent.HooksNested<A> editMatchingHook(io.alauda.devops.java.client.fluent.Predicate<V1alpha1PipelineHookBuilder> predicate){
            int index = -1;
            for (int i=0;i<hooks.size();i++) { 
            if (predicate.apply(hooks.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching hooks. No match found.");
            return setNewHookLike(index, buildHook(index));
    }

    
/**
 * This method has been deprecated, please use method buildJenkinsBinding instead.
 * @return The buildable object.
 */
@Deprecated public V1alpha1LocalObjectReference getJenkinsBinding(){
            return this.jenkinsBinding!=null?this.jenkinsBinding.build():null;
    }

    public V1alpha1LocalObjectReference buildJenkinsBinding(){
            return this.jenkinsBinding!=null?this.jenkinsBinding.build():null;
    }

    public A withJenkinsBinding(V1alpha1LocalObjectReference jenkinsBinding){
            _visitables.get("jenkinsBinding").remove(this.jenkinsBinding);
            if (jenkinsBinding!=null){ this.jenkinsBinding= new V1alpha1LocalObjectReferenceBuilder(jenkinsBinding); _visitables.get("jenkinsBinding").add(this.jenkinsBinding);} return (A) this;
    }

    public Boolean hasJenkinsBinding(){
            return this.jenkinsBinding != null;
    }

    public V1alpha1PipelineSpecFluent.JenkinsBindingNested<A> withNewJenkinsBinding(){
            return new JenkinsBindingNestedImpl();
    }

    public V1alpha1PipelineSpecFluent.JenkinsBindingNested<A> withNewJenkinsBindingLike(V1alpha1LocalObjectReference item){
            return new JenkinsBindingNestedImpl(item);
    }

    public V1alpha1PipelineSpecFluent.JenkinsBindingNested<A> editJenkinsBinding(){
            return withNewJenkinsBindingLike(getJenkinsBinding());
    }

    public V1alpha1PipelineSpecFluent.JenkinsBindingNested<A> editOrNewJenkinsBinding(){
            return withNewJenkinsBindingLike(getJenkinsBinding() != null ? getJenkinsBinding(): new V1alpha1LocalObjectReferenceBuilder().build());
    }

    public V1alpha1PipelineSpecFluent.JenkinsBindingNested<A> editOrNewJenkinsBindingLike(V1alpha1LocalObjectReference item){
            return withNewJenkinsBindingLike(getJenkinsBinding() != null ? getJenkinsBinding(): item);
    }

    public A addToParameters(int index,V1alpha1PipelineParameter item){
            if (this.parameters == null) {this.parameters = new ArrayList<V1alpha1PipelineParameterBuilder>();}
            V1alpha1PipelineParameterBuilder builder = new V1alpha1PipelineParameterBuilder(item);_visitables.get("parameters").add(index >= 0 ? index : _visitables.get("parameters").size(), builder);this.parameters.add(index >= 0 ? index : parameters.size(), builder); return (A)this;
    }

    public A setToParameters(int index,V1alpha1PipelineParameter item){
            if (this.parameters == null) {this.parameters = new ArrayList<V1alpha1PipelineParameterBuilder>();}
            V1alpha1PipelineParameterBuilder builder = new V1alpha1PipelineParameterBuilder(item);
            if (index < 0 || index >= _visitables.get("parameters").size()) { _visitables.get("parameters").add(builder); } else { _visitables.get("parameters").set(index, builder);}
            if (index < 0 || index >= parameters.size()) { parameters.add(builder); } else { parameters.set(index, builder);}
             return (A)this;
    }

    public A addToParameters(V1alpha1PipelineParameter... items){
            if (this.parameters == null) {this.parameters = new ArrayList<V1alpha1PipelineParameterBuilder>();}
            for (V1alpha1PipelineParameter item : items) {V1alpha1PipelineParameterBuilder builder = new V1alpha1PipelineParameterBuilder(item);_visitables.get("parameters").add(builder);this.parameters.add(builder);} return (A)this;
    }

    public A addAllToParameters(Collection<V1alpha1PipelineParameter> items){
            if (this.parameters == null) {this.parameters = new ArrayList<V1alpha1PipelineParameterBuilder>();}
            for (V1alpha1PipelineParameter item : items) {V1alpha1PipelineParameterBuilder builder = new V1alpha1PipelineParameterBuilder(item);_visitables.get("parameters").add(builder);this.parameters.add(builder);} return (A)this;
    }

    public A removeFromParameters(V1alpha1PipelineParameter... items){
            for (V1alpha1PipelineParameter item : items) {V1alpha1PipelineParameterBuilder builder = new V1alpha1PipelineParameterBuilder(item);_visitables.get("parameters").remove(builder);if (this.parameters != null) {this.parameters.remove(builder);}} return (A)this;
    }

    public A removeAllFromParameters(Collection<V1alpha1PipelineParameter> items){
            for (V1alpha1PipelineParameter item : items) {V1alpha1PipelineParameterBuilder builder = new V1alpha1PipelineParameterBuilder(item);_visitables.get("parameters").remove(builder);if (this.parameters != null) {this.parameters.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildParameters instead.
 * @return The buildable object.
 */
@Deprecated public List<V1alpha1PipelineParameter> getParameters(){
            return build(parameters);
    }

    public List<V1alpha1PipelineParameter> buildParameters(){
            return build(parameters);
    }

    public V1alpha1PipelineParameter buildParameter(int index){
            return this.parameters.get(index).build();
    }

    public V1alpha1PipelineParameter buildFirstParameter(){
            return this.parameters.get(0).build();
    }

    public V1alpha1PipelineParameter buildLastParameter(){
            return this.parameters.get(parameters.size() - 1).build();
    }

    public V1alpha1PipelineParameter buildMatchingParameter(io.alauda.devops.java.client.fluent.Predicate<V1alpha1PipelineParameterBuilder> predicate){
            for (V1alpha1PipelineParameterBuilder item: parameters) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public Boolean hasMatchingParameter(io.alauda.devops.java.client.fluent.Predicate<V1alpha1PipelineParameterBuilder> predicate){
            for (V1alpha1PipelineParameterBuilder item: parameters) { if(predicate.apply(item)){return true;} } return false;
    }

    public A withParameters(List<V1alpha1PipelineParameter> parameters){
            if (this.parameters != null) { _visitables.get("parameters").removeAll(this.parameters);}
            if (parameters != null) {this.parameters = new ArrayList<V1alpha1PipelineParameterBuilder>(); for (V1alpha1PipelineParameter item : parameters){this.addToParameters(item);}} else { this.parameters = null;} return (A) this;
    }

    public A withParameters(V1alpha1PipelineParameter... parameters){
            if (this.parameters != null) {this.parameters.clear();}
            if (parameters != null) {for (V1alpha1PipelineParameter item :parameters){ this.addToParameters(item);}} return (A) this;
    }

    public Boolean hasParameters(){
            return parameters != null && !parameters.isEmpty();
    }

    public V1alpha1PipelineSpecFluent.ParametersNested<A> addNewParameter(){
            return new ParametersNestedImpl();
    }

    public V1alpha1PipelineSpecFluent.ParametersNested<A> addNewParameterLike(V1alpha1PipelineParameter item){
            return new ParametersNestedImpl(-1, item);
    }

    public V1alpha1PipelineSpecFluent.ParametersNested<A> setNewParameterLike(int index,V1alpha1PipelineParameter item){
            return new ParametersNestedImpl(index, item);
    }

    public V1alpha1PipelineSpecFluent.ParametersNested<A> editParameter(int index){
            if (parameters.size() <= index) throw new RuntimeException("Can't edit parameters. Index exceeds size.");
            return setNewParameterLike(index, buildParameter(index));
    }

    public V1alpha1PipelineSpecFluent.ParametersNested<A> editFirstParameter(){
            if (parameters.size() == 0) throw new RuntimeException("Can't edit first parameters. The list is empty.");
            return setNewParameterLike(0, buildParameter(0));
    }

    public V1alpha1PipelineSpecFluent.ParametersNested<A> editLastParameter(){
            int index = parameters.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last parameters. The list is empty.");
            return setNewParameterLike(index, buildParameter(index));
    }

    public V1alpha1PipelineSpecFluent.ParametersNested<A> editMatchingParameter(io.alauda.devops.java.client.fluent.Predicate<V1alpha1PipelineParameterBuilder> predicate){
            int index = -1;
            for (int i=0;i<parameters.size();i++) { 
            if (predicate.apply(parameters.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching parameters. No match found.");
            return setNewParameterLike(index, buildParameter(index));
    }

    
/**
 * This method has been deprecated, please use method buildPipelineConfig instead.
 * @return The buildable object.
 */
@Deprecated public V1alpha1LocalObjectReference getPipelineConfig(){
            return this.pipelineConfig!=null?this.pipelineConfig.build():null;
    }

    public V1alpha1LocalObjectReference buildPipelineConfig(){
            return this.pipelineConfig!=null?this.pipelineConfig.build():null;
    }

    public A withPipelineConfig(V1alpha1LocalObjectReference pipelineConfig){
            _visitables.get("pipelineConfig").remove(this.pipelineConfig);
            if (pipelineConfig!=null){ this.pipelineConfig= new V1alpha1LocalObjectReferenceBuilder(pipelineConfig); _visitables.get("pipelineConfig").add(this.pipelineConfig);} return (A) this;
    }

    public Boolean hasPipelineConfig(){
            return this.pipelineConfig != null;
    }

    public V1alpha1PipelineSpecFluent.PipelineConfigNested<A> withNewPipelineConfig(){
            return new PipelineConfigNestedImpl();
    }

    public V1alpha1PipelineSpecFluent.PipelineConfigNested<A> withNewPipelineConfigLike(V1alpha1LocalObjectReference item){
            return new PipelineConfigNestedImpl(item);
    }

    public V1alpha1PipelineSpecFluent.PipelineConfigNested<A> editPipelineConfig(){
            return withNewPipelineConfigLike(getPipelineConfig());
    }

    public V1alpha1PipelineSpecFluent.PipelineConfigNested<A> editOrNewPipelineConfig(){
            return withNewPipelineConfigLike(getPipelineConfig() != null ? getPipelineConfig(): new V1alpha1LocalObjectReferenceBuilder().build());
    }

    public V1alpha1PipelineSpecFluent.PipelineConfigNested<A> editOrNewPipelineConfigLike(V1alpha1LocalObjectReference item){
            return withNewPipelineConfigLike(getPipelineConfig() != null ? getPipelineConfig(): item);
    }

    public String getRunPolicy(){
            return this.runPolicy;
    }

    public A withRunPolicy(String runPolicy){
            this.runPolicy=runPolicy; return (A) this;
    }

    public Boolean hasRunPolicy(){
            return this.runPolicy != null;
    }

    public A withNewRunPolicy(String arg1){
            return (A)withRunPolicy(new String(arg1));
    }

    public A withNewRunPolicy(StringBuilder arg1){
            return (A)withRunPolicy(new String(arg1));
    }

    public A withNewRunPolicy(StringBuffer arg1){
            return (A)withRunPolicy(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildSource instead.
 * @return The buildable object.
 */
@Deprecated public V1alpha1PipelineSource getSource(){
            return this.source!=null?this.source.build():null;
    }

    public V1alpha1PipelineSource buildSource(){
            return this.source!=null?this.source.build():null;
    }

    public A withSource(V1alpha1PipelineSource source){
            _visitables.get("source").remove(this.source);
            if (source!=null){ this.source= new V1alpha1PipelineSourceBuilder(source); _visitables.get("source").add(this.source);} return (A) this;
    }

    public Boolean hasSource(){
            return this.source != null;
    }

    public V1alpha1PipelineSpecFluent.SourceNested<A> withNewSource(){
            return new SourceNestedImpl();
    }

    public V1alpha1PipelineSpecFluent.SourceNested<A> withNewSourceLike(V1alpha1PipelineSource item){
            return new SourceNestedImpl(item);
    }

    public V1alpha1PipelineSpecFluent.SourceNested<A> editSource(){
            return withNewSourceLike(getSource());
    }

    public V1alpha1PipelineSpecFluent.SourceNested<A> editOrNewSource(){
            return withNewSourceLike(getSource() != null ? getSource(): new V1alpha1PipelineSourceBuilder().build());
    }

    public V1alpha1PipelineSpecFluent.SourceNested<A> editOrNewSourceLike(V1alpha1PipelineSource item){
            return withNewSourceLike(getSource() != null ? getSource(): item);
    }

    
/**
 * This method has been deprecated, please use method buildStrategy instead.
 * @return The buildable object.
 */
@Deprecated public V1alpha1PipelineStrategy getStrategy(){
            return this.strategy!=null?this.strategy.build():null;
    }

    public V1alpha1PipelineStrategy buildStrategy(){
            return this.strategy!=null?this.strategy.build():null;
    }

    public A withStrategy(V1alpha1PipelineStrategy strategy){
            _visitables.get("strategy").remove(this.strategy);
            if (strategy!=null){ this.strategy= new V1alpha1PipelineStrategyBuilder(strategy); _visitables.get("strategy").add(this.strategy);} return (A) this;
    }

    public Boolean hasStrategy(){
            return this.strategy != null;
    }

    public V1alpha1PipelineSpecFluent.StrategyNested<A> withNewStrategy(){
            return new StrategyNestedImpl();
    }

    public V1alpha1PipelineSpecFluent.StrategyNested<A> withNewStrategyLike(V1alpha1PipelineStrategy item){
            return new StrategyNestedImpl(item);
    }

    public V1alpha1PipelineSpecFluent.StrategyNested<A> editStrategy(){
            return withNewStrategyLike(getStrategy());
    }

    public V1alpha1PipelineSpecFluent.StrategyNested<A> editOrNewStrategy(){
            return withNewStrategyLike(getStrategy() != null ? getStrategy(): new V1alpha1PipelineStrategyBuilder().build());
    }

    public V1alpha1PipelineSpecFluent.StrategyNested<A> editOrNewStrategyLike(V1alpha1PipelineStrategy item){
            return withNewStrategyLike(getStrategy() != null ? getStrategy(): item);
    }

    public A addToTriggers(int index,V1alpha1PipelineTrigger item){
            if (this.triggers == null) {this.triggers = new ArrayList<V1alpha1PipelineTriggerBuilder>();}
            V1alpha1PipelineTriggerBuilder builder = new V1alpha1PipelineTriggerBuilder(item);_visitables.get("triggers").add(index >= 0 ? index : _visitables.get("triggers").size(), builder);this.triggers.add(index >= 0 ? index : triggers.size(), builder); return (A)this;
    }

    public A setToTriggers(int index,V1alpha1PipelineTrigger item){
            if (this.triggers == null) {this.triggers = new ArrayList<V1alpha1PipelineTriggerBuilder>();}
            V1alpha1PipelineTriggerBuilder builder = new V1alpha1PipelineTriggerBuilder(item);
            if (index < 0 || index >= _visitables.get("triggers").size()) { _visitables.get("triggers").add(builder); } else { _visitables.get("triggers").set(index, builder);}
            if (index < 0 || index >= triggers.size()) { triggers.add(builder); } else { triggers.set(index, builder);}
             return (A)this;
    }

    public A addToTriggers(V1alpha1PipelineTrigger... items){
            if (this.triggers == null) {this.triggers = new ArrayList<V1alpha1PipelineTriggerBuilder>();}
            for (V1alpha1PipelineTrigger item : items) {V1alpha1PipelineTriggerBuilder builder = new V1alpha1PipelineTriggerBuilder(item);_visitables.get("triggers").add(builder);this.triggers.add(builder);} return (A)this;
    }

    public A addAllToTriggers(Collection<V1alpha1PipelineTrigger> items){
            if (this.triggers == null) {this.triggers = new ArrayList<V1alpha1PipelineTriggerBuilder>();}
            for (V1alpha1PipelineTrigger item : items) {V1alpha1PipelineTriggerBuilder builder = new V1alpha1PipelineTriggerBuilder(item);_visitables.get("triggers").add(builder);this.triggers.add(builder);} return (A)this;
    }

    public A removeFromTriggers(V1alpha1PipelineTrigger... items){
            for (V1alpha1PipelineTrigger item : items) {V1alpha1PipelineTriggerBuilder builder = new V1alpha1PipelineTriggerBuilder(item);_visitables.get("triggers").remove(builder);if (this.triggers != null) {this.triggers.remove(builder);}} return (A)this;
    }

    public A removeAllFromTriggers(Collection<V1alpha1PipelineTrigger> items){
            for (V1alpha1PipelineTrigger item : items) {V1alpha1PipelineTriggerBuilder builder = new V1alpha1PipelineTriggerBuilder(item);_visitables.get("triggers").remove(builder);if (this.triggers != null) {this.triggers.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildTriggers instead.
 * @return The buildable object.
 */
@Deprecated public List<V1alpha1PipelineTrigger> getTriggers(){
            return build(triggers);
    }

    public List<V1alpha1PipelineTrigger> buildTriggers(){
            return build(triggers);
    }

    public V1alpha1PipelineTrigger buildTrigger(int index){
            return this.triggers.get(index).build();
    }

    public V1alpha1PipelineTrigger buildFirstTrigger(){
            return this.triggers.get(0).build();
    }

    public V1alpha1PipelineTrigger buildLastTrigger(){
            return this.triggers.get(triggers.size() - 1).build();
    }

    public V1alpha1PipelineTrigger buildMatchingTrigger(io.alauda.devops.java.client.fluent.Predicate<V1alpha1PipelineTriggerBuilder> predicate){
            for (V1alpha1PipelineTriggerBuilder item: triggers) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public Boolean hasMatchingTrigger(io.alauda.devops.java.client.fluent.Predicate<V1alpha1PipelineTriggerBuilder> predicate){
            for (V1alpha1PipelineTriggerBuilder item: triggers) { if(predicate.apply(item)){return true;} } return false;
    }

    public A withTriggers(List<V1alpha1PipelineTrigger> triggers){
            if (this.triggers != null) { _visitables.get("triggers").removeAll(this.triggers);}
            if (triggers != null) {this.triggers = new ArrayList<V1alpha1PipelineTriggerBuilder>(); for (V1alpha1PipelineTrigger item : triggers){this.addToTriggers(item);}} else { this.triggers = null;} return (A) this;
    }

    public A withTriggers(V1alpha1PipelineTrigger... triggers){
            if (this.triggers != null) {this.triggers.clear();}
            if (triggers != null) {for (V1alpha1PipelineTrigger item :triggers){ this.addToTriggers(item);}} return (A) this;
    }

    public Boolean hasTriggers(){
            return triggers != null && !triggers.isEmpty();
    }

    public V1alpha1PipelineSpecFluent.TriggersNested<A> addNewTrigger(){
            return new TriggersNestedImpl();
    }

    public V1alpha1PipelineSpecFluent.TriggersNested<A> addNewTriggerLike(V1alpha1PipelineTrigger item){
            return new TriggersNestedImpl(-1, item);
    }

    public V1alpha1PipelineSpecFluent.TriggersNested<A> setNewTriggerLike(int index,V1alpha1PipelineTrigger item){
            return new TriggersNestedImpl(index, item);
    }

    public V1alpha1PipelineSpecFluent.TriggersNested<A> editTrigger(int index){
            if (triggers.size() <= index) throw new RuntimeException("Can't edit triggers. Index exceeds size.");
            return setNewTriggerLike(index, buildTrigger(index));
    }

    public V1alpha1PipelineSpecFluent.TriggersNested<A> editFirstTrigger(){
            if (triggers.size() == 0) throw new RuntimeException("Can't edit first triggers. The list is empty.");
            return setNewTriggerLike(0, buildTrigger(0));
    }

    public V1alpha1PipelineSpecFluent.TriggersNested<A> editLastTrigger(){
            int index = triggers.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last triggers. The list is empty.");
            return setNewTriggerLike(index, buildTrigger(index));
    }

    public V1alpha1PipelineSpecFluent.TriggersNested<A> editMatchingTrigger(io.alauda.devops.java.client.fluent.Predicate<V1alpha1PipelineTriggerBuilder> predicate){
            int index = -1;
            for (int i=0;i<triggers.size();i++) { 
            if (predicate.apply(triggers.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching triggers. No match found.");
            return setNewTriggerLike(index, buildTrigger(index));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1PipelineSpecFluentImpl that = (V1alpha1PipelineSpecFluentImpl) o;
            if (cancel != null ? !cancel.equals(that.cancel) :that.cancel != null) return false;
            if (cause != null ? !cause.equals(that.cause) :that.cause != null) return false;
            if (hooks != null ? !hooks.equals(that.hooks) :that.hooks != null) return false;
            if (jenkinsBinding != null ? !jenkinsBinding.equals(that.jenkinsBinding) :that.jenkinsBinding != null) return false;
            if (parameters != null ? !parameters.equals(that.parameters) :that.parameters != null) return false;
            if (pipelineConfig != null ? !pipelineConfig.equals(that.pipelineConfig) :that.pipelineConfig != null) return false;
            if (runPolicy != null ? !runPolicy.equals(that.runPolicy) :that.runPolicy != null) return false;
            if (source != null ? !source.equals(that.source) :that.source != null) return false;
            if (strategy != null ? !strategy.equals(that.strategy) :that.strategy != null) return false;
            if (triggers != null ? !triggers.equals(that.triggers) :that.triggers != null) return false;
            return true;
    }


    public class CauseNestedImpl<N> extends V1alpha1PipelineCauseFluentImpl<V1alpha1PipelineSpecFluent.CauseNested<N>> implements V1alpha1PipelineSpecFluent.CauseNested<N>,io.alauda.devops.java.client.fluent.Nested<N>{

            private final V1alpha1PipelineCauseBuilder builder;
    
            CauseNestedImpl(V1alpha1PipelineCause item){
                    this.builder = new V1alpha1PipelineCauseBuilder(this, item);
            }
            CauseNestedImpl(){
                    this.builder = new V1alpha1PipelineCauseBuilder(this);
            }
    
    public N and(){
            return (N) V1alpha1PipelineSpecFluentImpl.this.withCause(builder.build());
    }
    public N endCause(){
            return and();
    }

}
    public class HooksNestedImpl<N> extends V1alpha1PipelineHookFluentImpl<V1alpha1PipelineSpecFluent.HooksNested<N>> implements V1alpha1PipelineSpecFluent.HooksNested<N>,io.alauda.devops.java.client.fluent.Nested<N>{

            private final V1alpha1PipelineHookBuilder builder;
        private final int index;
    
            HooksNestedImpl(int index,V1alpha1PipelineHook item){
                    this.index = index;
                    this.builder = new V1alpha1PipelineHookBuilder(this, item);
            }
            HooksNestedImpl(){
                    this.index = -1;
                    this.builder = new V1alpha1PipelineHookBuilder(this);
            }
    
    public N and(){
            return (N) V1alpha1PipelineSpecFluentImpl.this.setToHooks(index, builder.build());
    }
    public N endHook(){
            return and();
    }

}
    public class JenkinsBindingNestedImpl<N> extends V1alpha1LocalObjectReferenceFluentImpl<V1alpha1PipelineSpecFluent.JenkinsBindingNested<N>> implements V1alpha1PipelineSpecFluent.JenkinsBindingNested<N>,io.alauda.devops.java.client.fluent.Nested<N>{

            private final V1alpha1LocalObjectReferenceBuilder builder;
    
            JenkinsBindingNestedImpl(V1alpha1LocalObjectReference item){
                    this.builder = new V1alpha1LocalObjectReferenceBuilder(this, item);
            }
            JenkinsBindingNestedImpl(){
                    this.builder = new V1alpha1LocalObjectReferenceBuilder(this);
            }
    
    public N and(){
            return (N) V1alpha1PipelineSpecFluentImpl.this.withJenkinsBinding(builder.build());
    }
    public N endJenkinsBinding(){
            return and();
    }

}
    public class ParametersNestedImpl<N> extends V1alpha1PipelineParameterFluentImpl<V1alpha1PipelineSpecFluent.ParametersNested<N>> implements V1alpha1PipelineSpecFluent.ParametersNested<N>,io.alauda.devops.java.client.fluent.Nested<N>{

            private final V1alpha1PipelineParameterBuilder builder;
        private final int index;
    
            ParametersNestedImpl(int index,V1alpha1PipelineParameter item){
                    this.index = index;
                    this.builder = new V1alpha1PipelineParameterBuilder(this, item);
            }
            ParametersNestedImpl(){
                    this.index = -1;
                    this.builder = new V1alpha1PipelineParameterBuilder(this);
            }
    
    public N and(){
            return (N) V1alpha1PipelineSpecFluentImpl.this.setToParameters(index, builder.build());
    }
    public N endParameter(){
            return and();
    }

}
    public class PipelineConfigNestedImpl<N> extends V1alpha1LocalObjectReferenceFluentImpl<V1alpha1PipelineSpecFluent.PipelineConfigNested<N>> implements V1alpha1PipelineSpecFluent.PipelineConfigNested<N>,io.alauda.devops.java.client.fluent.Nested<N>{

            private final V1alpha1LocalObjectReferenceBuilder builder;
    
            PipelineConfigNestedImpl(V1alpha1LocalObjectReference item){
                    this.builder = new V1alpha1LocalObjectReferenceBuilder(this, item);
            }
            PipelineConfigNestedImpl(){
                    this.builder = new V1alpha1LocalObjectReferenceBuilder(this);
            }
    
    public N and(){
            return (N) V1alpha1PipelineSpecFluentImpl.this.withPipelineConfig(builder.build());
    }
    public N endPipelineConfig(){
            return and();
    }

}
    public class SourceNestedImpl<N> extends V1alpha1PipelineSourceFluentImpl<V1alpha1PipelineSpecFluent.SourceNested<N>> implements V1alpha1PipelineSpecFluent.SourceNested<N>,io.alauda.devops.java.client.fluent.Nested<N>{

            private final V1alpha1PipelineSourceBuilder builder;
    
            SourceNestedImpl(V1alpha1PipelineSource item){
                    this.builder = new V1alpha1PipelineSourceBuilder(this, item);
            }
            SourceNestedImpl(){
                    this.builder = new V1alpha1PipelineSourceBuilder(this);
            }
    
    public N and(){
            return (N) V1alpha1PipelineSpecFluentImpl.this.withSource(builder.build());
    }
    public N endSource(){
            return and();
    }

}
    public class StrategyNestedImpl<N> extends V1alpha1PipelineStrategyFluentImpl<V1alpha1PipelineSpecFluent.StrategyNested<N>> implements V1alpha1PipelineSpecFluent.StrategyNested<N>,io.alauda.devops.java.client.fluent.Nested<N>{

            private final V1alpha1PipelineStrategyBuilder builder;
    
            StrategyNestedImpl(V1alpha1PipelineStrategy item){
                    this.builder = new V1alpha1PipelineStrategyBuilder(this, item);
            }
            StrategyNestedImpl(){
                    this.builder = new V1alpha1PipelineStrategyBuilder(this);
            }
    
    public N and(){
            return (N) V1alpha1PipelineSpecFluentImpl.this.withStrategy(builder.build());
    }
    public N endStrategy(){
            return and();
    }

}
    public class TriggersNestedImpl<N> extends V1alpha1PipelineTriggerFluentImpl<V1alpha1PipelineSpecFluent.TriggersNested<N>> implements V1alpha1PipelineSpecFluent.TriggersNested<N>,io.alauda.devops.java.client.fluent.Nested<N>{

            private final V1alpha1PipelineTriggerBuilder builder;
        private final int index;
    
            TriggersNestedImpl(int index,V1alpha1PipelineTrigger item){
                    this.index = index;
                    this.builder = new V1alpha1PipelineTriggerBuilder(this, item);
            }
            TriggersNestedImpl(){
                    this.index = -1;
                    this.builder = new V1alpha1PipelineTriggerBuilder(this);
            }
    
    public N and(){
            return (N) V1alpha1PipelineSpecFluentImpl.this.setToTriggers(index, builder.build());
    }
    public N endTrigger(){
            return and();
    }

}


}
