package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1PipelineSpecBuilder extends V1alpha1PipelineSpecFluentImpl<V1alpha1PipelineSpecBuilder> implements VisitableBuilder<V1alpha1PipelineSpec,V1alpha1PipelineSpecBuilder>{

    V1alpha1PipelineSpecFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1PipelineSpecBuilder(){
            this(true);
    }
    public V1alpha1PipelineSpecBuilder(Boolean validationEnabled){
            this(new V1alpha1PipelineSpec(), validationEnabled);
    }
    public V1alpha1PipelineSpecBuilder(V1alpha1PipelineSpecFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1PipelineSpecBuilder(V1alpha1PipelineSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1PipelineSpec(), validationEnabled);
    }
    public V1alpha1PipelineSpecBuilder(V1alpha1PipelineSpecFluent<?> fluent,V1alpha1PipelineSpec instance){
            this(fluent, instance, true);
    }
    public V1alpha1PipelineSpecBuilder(V1alpha1PipelineSpecFluent<?> fluent,V1alpha1PipelineSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withCancel(instance.isCancel());

            fluent.withCause(instance.getCause());

            fluent.withHooks(instance.getHooks());

            fluent.withJenkinsBinding(instance.getJenkinsBinding());

            fluent.withParameters(instance.getParameters());

            fluent.withPipelineConfig(instance.getPipelineConfig());

            fluent.withRunPolicy(instance.getRunPolicy());

            fluent.withSource(instance.getSource());

            fluent.withStrategy(instance.getStrategy());

            fluent.withTriggers(instance.getTriggers());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1PipelineSpecBuilder(V1alpha1PipelineSpec instance){
            this(instance,true);
    }
    public V1alpha1PipelineSpecBuilder(V1alpha1PipelineSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withCancel(instance.isCancel());

            this.withCause(instance.getCause());

            this.withHooks(instance.getHooks());

            this.withJenkinsBinding(instance.getJenkinsBinding());

            this.withParameters(instance.getParameters());

            this.withPipelineConfig(instance.getPipelineConfig());

            this.withRunPolicy(instance.getRunPolicy());

            this.withSource(instance.getSource());

            this.withStrategy(instance.getStrategy());

            this.withTriggers(instance.getTriggers());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1PipelineSpec build(){
            V1alpha1PipelineSpec buildable = new V1alpha1PipelineSpec();
            buildable.setCancel(fluent.isCancel());
            buildable.setCause(fluent.getCause());
            buildable.setHooks(fluent.getHooks());
            buildable.setJenkinsBinding(fluent.getJenkinsBinding());
            buildable.setParameters(fluent.getParameters());
            buildable.setPipelineConfig(fluent.getPipelineConfig());
            buildable.setRunPolicy(fluent.getRunPolicy());
            buildable.setSource(fluent.getSource());
            buildable.setStrategy(fluent.getStrategy());
            buildable.setTriggers(fluent.getTriggers());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1PipelineSpecBuilder that = (V1alpha1PipelineSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
