package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1PipelineSourceDiskBuilder extends V1alpha1PipelineSourceDiskFluentImpl<V1alpha1PipelineSourceDiskBuilder> implements VisitableBuilder<V1alpha1PipelineSourceDisk,V1alpha1PipelineSourceDiskBuilder>{

    V1alpha1PipelineSourceDiskFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1PipelineSourceDiskBuilder(){
            this(true);
    }
    public V1alpha1PipelineSourceDiskBuilder(Boolean validationEnabled){
            this(new V1alpha1PipelineSourceDisk(), validationEnabled);
    }
    public V1alpha1PipelineSourceDiskBuilder(V1alpha1PipelineSourceDiskFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1PipelineSourceDiskBuilder(V1alpha1PipelineSourceDiskFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1PipelineSourceDisk(), validationEnabled);
    }
    public V1alpha1PipelineSourceDiskBuilder(V1alpha1PipelineSourceDiskFluent<?> fluent,V1alpha1PipelineSourceDisk instance){
            this(fluent, instance, true);
    }
    public V1alpha1PipelineSourceDiskBuilder(V1alpha1PipelineSourceDiskFluent<?> fluent,V1alpha1PipelineSourceDisk instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withPath(instance.getPath());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1PipelineSourceDiskBuilder(V1alpha1PipelineSourceDisk instance){
            this(instance,true);
    }
    public V1alpha1PipelineSourceDiskBuilder(V1alpha1PipelineSourceDisk instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withPath(instance.getPath());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1PipelineSourceDisk build(){
            V1alpha1PipelineSourceDisk buildable = new V1alpha1PipelineSourceDisk();
            buildable.setPath(fluent.getPath());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1PipelineSourceDiskBuilder that = (V1alpha1PipelineSourceDiskBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
