package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1PipelineConfigTemplateBuilder extends V1alpha1PipelineConfigTemplateFluentImpl<V1alpha1PipelineConfigTemplateBuilder> implements VisitableBuilder<V1alpha1PipelineConfigTemplate,V1alpha1PipelineConfigTemplateBuilder>{

    V1alpha1PipelineConfigTemplateFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1PipelineConfigTemplateBuilder(){
            this(true);
    }
    public V1alpha1PipelineConfigTemplateBuilder(Boolean validationEnabled){
            this(new V1alpha1PipelineConfigTemplate(), validationEnabled);
    }
    public V1alpha1PipelineConfigTemplateBuilder(V1alpha1PipelineConfigTemplateFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1PipelineConfigTemplateBuilder(V1alpha1PipelineConfigTemplateFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1PipelineConfigTemplate(), validationEnabled);
    }
    public V1alpha1PipelineConfigTemplateBuilder(V1alpha1PipelineConfigTemplateFluent<?> fluent,V1alpha1PipelineConfigTemplate instance){
            this(fluent, instance, true);
    }
    public V1alpha1PipelineConfigTemplateBuilder(V1alpha1PipelineConfigTemplateFluent<?> fluent,V1alpha1PipelineConfigTemplate instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion());

            fluent.withKind(instance.getKind());

            fluent.withLabels(instance.getLabels());

            fluent.withMetadata(instance.getMetadata());

            fluent.withSpec(instance.getSpec());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1PipelineConfigTemplateBuilder(V1alpha1PipelineConfigTemplate instance){
            this(instance,true);
    }
    public V1alpha1PipelineConfigTemplateBuilder(V1alpha1PipelineConfigTemplate instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion());

            this.withKind(instance.getKind());

            this.withLabels(instance.getLabels());

            this.withMetadata(instance.getMetadata());

            this.withSpec(instance.getSpec());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1PipelineConfigTemplate build(){
            V1alpha1PipelineConfigTemplate buildable = new V1alpha1PipelineConfigTemplate();
            buildable.setApiVersion(fluent.getApiVersion());
            buildable.setKind(fluent.getKind());
            buildable.setLabels(fluent.getLabels());
            buildable.setMetadata(fluent.getMetadata());
            buildable.setSpec(fluent.getSpec());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1PipelineConfigTemplateBuilder that = (V1alpha1PipelineConfigTemplateBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
