package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1PipelineConfigStatusBuilder extends V1alpha1PipelineConfigStatusFluentImpl<V1alpha1PipelineConfigStatusBuilder> implements VisitableBuilder<V1alpha1PipelineConfigStatus,V1alpha1PipelineConfigStatusBuilder>{

    V1alpha1PipelineConfigStatusFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1PipelineConfigStatusBuilder(){
            this(true);
    }
    public V1alpha1PipelineConfigStatusBuilder(Boolean validationEnabled){
            this(new V1alpha1PipelineConfigStatus(), validationEnabled);
    }
    public V1alpha1PipelineConfigStatusBuilder(V1alpha1PipelineConfigStatusFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1PipelineConfigStatusBuilder(V1alpha1PipelineConfigStatusFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1PipelineConfigStatus(), validationEnabled);
    }
    public V1alpha1PipelineConfigStatusBuilder(V1alpha1PipelineConfigStatusFluent<?> fluent,V1alpha1PipelineConfigStatus instance){
            this(fluent, instance, true);
    }
    public V1alpha1PipelineConfigStatusBuilder(V1alpha1PipelineConfigStatusFluent<?> fluent,V1alpha1PipelineConfigStatus instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withConditions(instance.getConditions());

            fluent.withLastUpdated(instance.getLastUpdated());

            fluent.withMessage(instance.getMessage());

            fluent.withPhase(instance.getPhase());

            fluent.withReason(instance.getReason());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1PipelineConfigStatusBuilder(V1alpha1PipelineConfigStatus instance){
            this(instance,true);
    }
    public V1alpha1PipelineConfigStatusBuilder(V1alpha1PipelineConfigStatus instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withConditions(instance.getConditions());

            this.withLastUpdated(instance.getLastUpdated());

            this.withMessage(instance.getMessage());

            this.withPhase(instance.getPhase());

            this.withReason(instance.getReason());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1PipelineConfigStatus build(){
            V1alpha1PipelineConfigStatus buildable = new V1alpha1PipelineConfigStatus();
            buildable.setConditions(fluent.getConditions());
            buildable.setLastUpdated(fluent.getLastUpdated());
            buildable.setMessage(fluent.getMessage());
            buildable.setPhase(fluent.getPhase());
            buildable.setReason(fluent.getReason());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1PipelineConfigStatusBuilder that = (V1alpha1PipelineConfigStatusBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
