package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1PipelineBlueOceanParameterBuilder extends V1alpha1PipelineBlueOceanParameterFluentImpl<V1alpha1PipelineBlueOceanParameterBuilder> implements VisitableBuilder<V1alpha1PipelineBlueOceanParameter,V1alpha1PipelineBlueOceanParameterBuilder>{

    V1alpha1PipelineBlueOceanParameterFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1PipelineBlueOceanParameterBuilder(){
            this(true);
    }
    public V1alpha1PipelineBlueOceanParameterBuilder(Boolean validationEnabled){
            this(new V1alpha1PipelineBlueOceanParameter(), validationEnabled);
    }
    public V1alpha1PipelineBlueOceanParameterBuilder(V1alpha1PipelineBlueOceanParameterFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1PipelineBlueOceanParameterBuilder(V1alpha1PipelineBlueOceanParameterFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1PipelineBlueOceanParameter(), validationEnabled);
    }
    public V1alpha1PipelineBlueOceanParameterBuilder(V1alpha1PipelineBlueOceanParameterFluent<?> fluent,V1alpha1PipelineBlueOceanParameter instance){
            this(fluent, instance, true);
    }
    public V1alpha1PipelineBlueOceanParameterBuilder(V1alpha1PipelineBlueOceanParameterFluent<?> fluent,V1alpha1PipelineBlueOceanParameter instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withPipelineBlueOceanRef(instance.getPipelineBlueOceanRef());

            fluent.withDefaultParameterValue(instance.getDefaultParameterValue());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1PipelineBlueOceanParameterBuilder(V1alpha1PipelineBlueOceanParameter instance){
            this(instance,true);
    }
    public V1alpha1PipelineBlueOceanParameterBuilder(V1alpha1PipelineBlueOceanParameter instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withPipelineBlueOceanRef(instance.getPipelineBlueOceanRef());

            this.withDefaultParameterValue(instance.getDefaultParameterValue());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1PipelineBlueOceanParameter build(){
            V1alpha1PipelineBlueOceanParameter buildable = new V1alpha1PipelineBlueOceanParameter();
            buildable.setPipelineBlueOceanRef(fluent.getPipelineBlueOceanRef());
            buildable.setDefaultParameterValue(fluent.getDefaultParameterValue());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1PipelineBlueOceanParameterBuilder that = (V1alpha1PipelineBlueOceanParameterBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
