package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1ListIssuesOptionsBuilder extends V1alpha1ListIssuesOptionsFluentImpl<V1alpha1ListIssuesOptionsBuilder> implements VisitableBuilder<V1alpha1ListIssuesOptions,V1alpha1ListIssuesOptionsBuilder>{

    V1alpha1ListIssuesOptionsFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1ListIssuesOptionsBuilder(){
            this(true);
    }
    public V1alpha1ListIssuesOptionsBuilder(Boolean validationEnabled){
            this(new V1alpha1ListIssuesOptions(), validationEnabled);
    }
    public V1alpha1ListIssuesOptionsBuilder(V1alpha1ListIssuesOptionsFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1ListIssuesOptionsBuilder(V1alpha1ListIssuesOptionsFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1ListIssuesOptions(), validationEnabled);
    }
    public V1alpha1ListIssuesOptionsBuilder(V1alpha1ListIssuesOptionsFluent<?> fluent,V1alpha1ListIssuesOptions instance){
            this(fluent, instance, true);
    }
    public V1alpha1ListIssuesOptionsBuilder(V1alpha1ListIssuesOptionsFluent<?> fluent,V1alpha1ListIssuesOptions instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion());

            fluent.withIssuekey(instance.getIssuekey());

            fluent.withKind(instance.getKind());

            fluent.withOrderby(instance.getOrderby());

            fluent.withPage(instance.getPage());

            fluent.withPagesize(instance.getPagesize());

            fluent.withPriority(instance.getPriority());

            fluent.withProject(instance.getProject());

            fluent.withProjects(instance.getProjects());

            fluent.withSort(instance.getSort());

            fluent.withStatus(instance.getStatus());

            fluent.withSummary(instance.getSummary());

            fluent.withType(instance.getType());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1ListIssuesOptionsBuilder(V1alpha1ListIssuesOptions instance){
            this(instance,true);
    }
    public V1alpha1ListIssuesOptionsBuilder(V1alpha1ListIssuesOptions instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion());

            this.withIssuekey(instance.getIssuekey());

            this.withKind(instance.getKind());

            this.withOrderby(instance.getOrderby());

            this.withPage(instance.getPage());

            this.withPagesize(instance.getPagesize());

            this.withPriority(instance.getPriority());

            this.withProject(instance.getProject());

            this.withProjects(instance.getProjects());

            this.withSort(instance.getSort());

            this.withStatus(instance.getStatus());

            this.withSummary(instance.getSummary());

            this.withType(instance.getType());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1ListIssuesOptions build(){
            V1alpha1ListIssuesOptions buildable = new V1alpha1ListIssuesOptions();
            buildable.setApiVersion(fluent.getApiVersion());
            buildable.setIssuekey(fluent.getIssuekey());
            buildable.setKind(fluent.getKind());
            buildable.setOrderby(fluent.getOrderby());
            buildable.setPage(fluent.getPage());
            buildable.setPagesize(fluent.getPagesize());
            buildable.setPriority(fluent.getPriority());
            buildable.setProject(fluent.getProject());
            buildable.setProjects(fluent.getProjects());
            buildable.setSort(fluent.getSort());
            buildable.setStatus(fluent.getStatus());
            buildable.setSummary(fluent.getSummary());
            buildable.setType(fluent.getType());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1ListIssuesOptionsBuilder that = (V1alpha1ListIssuesOptionsBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
