package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1JenkinsfilePreviewOptionsBuilder extends V1alpha1JenkinsfilePreviewOptionsFluentImpl<V1alpha1JenkinsfilePreviewOptionsBuilder> implements VisitableBuilder<V1alpha1JenkinsfilePreviewOptions,V1alpha1JenkinsfilePreviewOptionsBuilder>{

    V1alpha1JenkinsfilePreviewOptionsFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1JenkinsfilePreviewOptionsBuilder(){
            this(true);
    }
    public V1alpha1JenkinsfilePreviewOptionsBuilder(Boolean validationEnabled){
            this(new V1alpha1JenkinsfilePreviewOptions(), validationEnabled);
    }
    public V1alpha1JenkinsfilePreviewOptionsBuilder(V1alpha1JenkinsfilePreviewOptionsFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1JenkinsfilePreviewOptionsBuilder(V1alpha1JenkinsfilePreviewOptionsFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1JenkinsfilePreviewOptions(), validationEnabled);
    }
    public V1alpha1JenkinsfilePreviewOptionsBuilder(V1alpha1JenkinsfilePreviewOptionsFluent<?> fluent,V1alpha1JenkinsfilePreviewOptions instance){
            this(fluent, instance, true);
    }
    public V1alpha1JenkinsfilePreviewOptionsBuilder(V1alpha1JenkinsfilePreviewOptionsFluent<?> fluent,V1alpha1JenkinsfilePreviewOptions instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion());

            fluent.withEnvironments(instance.getEnvironments());

            fluent.withKind(instance.getKind());

            fluent.withSource(instance.getSource());

            fluent.withTemplate(instance.getTemplate());

            fluent.withValues(instance.getValues());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1JenkinsfilePreviewOptionsBuilder(V1alpha1JenkinsfilePreviewOptions instance){
            this(instance,true);
    }
    public V1alpha1JenkinsfilePreviewOptionsBuilder(V1alpha1JenkinsfilePreviewOptions instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion());

            this.withEnvironments(instance.getEnvironments());

            this.withKind(instance.getKind());

            this.withSource(instance.getSource());

            this.withTemplate(instance.getTemplate());

            this.withValues(instance.getValues());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1JenkinsfilePreviewOptions build(){
            V1alpha1JenkinsfilePreviewOptions buildable = new V1alpha1JenkinsfilePreviewOptions();
            buildable.setApiVersion(fluent.getApiVersion());
            buildable.setEnvironments(fluent.getEnvironments());
            buildable.setKind(fluent.getKind());
            buildable.setSource(fluent.getSource());
            buildable.setTemplate(fluent.getTemplate());
            buildable.setValues(fluent.getValues());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1JenkinsfilePreviewOptionsBuilder that = (V1alpha1JenkinsfilePreviewOptionsBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
