package io.alauda.devops.java.client.models;

import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.alauda.devops.java.client.fluent.Nested;
import java.util.ArrayList;
import java.lang.String;
import org.joda.time.DateTime;
import io.alauda.devops.java.client.fluent.Predicate;
import java.lang.Deprecated;
import io.alauda.devops.java.client.fluent.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;

public class V1alpha1JenkinsStatusFluentImpl<A extends V1alpha1JenkinsStatusFluent<A>> extends io.alauda.devops.java.client.fluent.BaseFluent<A> implements V1alpha1JenkinsStatusFluent<A>{

    private List<V1alpha1BindingConditionBuilder> conditions;
    private V1alpha1HostPortStatusBuilder http;
    private DateTime lastUpdated;
    private String message;
    private String phase;
    private String reason;

    public V1alpha1JenkinsStatusFluentImpl(){
    }
    public V1alpha1JenkinsStatusFluentImpl(V1alpha1JenkinsStatus instance){
            this.withConditions(instance.getConditions());

            this.withHttp(instance.getHttp());

            this.withLastUpdated(instance.getLastUpdated());

            this.withMessage(instance.getMessage());

            this.withPhase(instance.getPhase());

            this.withReason(instance.getReason());

    }

    public A addToConditions(int index,V1alpha1BindingCondition item){
            if (this.conditions == null) {this.conditions = new ArrayList<V1alpha1BindingConditionBuilder>();}
            V1alpha1BindingConditionBuilder builder = new V1alpha1BindingConditionBuilder(item);_visitables.get("conditions").add(index >= 0 ? index : _visitables.get("conditions").size(), builder);this.conditions.add(index >= 0 ? index : conditions.size(), builder); return (A)this;
    }

    public A setToConditions(int index,V1alpha1BindingCondition item){
            if (this.conditions == null) {this.conditions = new ArrayList<V1alpha1BindingConditionBuilder>();}
            V1alpha1BindingConditionBuilder builder = new V1alpha1BindingConditionBuilder(item);
            if (index < 0 || index >= _visitables.get("conditions").size()) { _visitables.get("conditions").add(builder); } else { _visitables.get("conditions").set(index, builder);}
            if (index < 0 || index >= conditions.size()) { conditions.add(builder); } else { conditions.set(index, builder);}
             return (A)this;
    }

    public A addToConditions(V1alpha1BindingCondition... items){
            if (this.conditions == null) {this.conditions = new ArrayList<V1alpha1BindingConditionBuilder>();}
            for (V1alpha1BindingCondition item : items) {V1alpha1BindingConditionBuilder builder = new V1alpha1BindingConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A addAllToConditions(Collection<V1alpha1BindingCondition> items){
            if (this.conditions == null) {this.conditions = new ArrayList<V1alpha1BindingConditionBuilder>();}
            for (V1alpha1BindingCondition item : items) {V1alpha1BindingConditionBuilder builder = new V1alpha1BindingConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A removeFromConditions(V1alpha1BindingCondition... items){
            for (V1alpha1BindingCondition item : items) {V1alpha1BindingConditionBuilder builder = new V1alpha1BindingConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    public A removeAllFromConditions(Collection<V1alpha1BindingCondition> items){
            for (V1alpha1BindingCondition item : items) {V1alpha1BindingConditionBuilder builder = new V1alpha1BindingConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildConditions instead.
 * @return The buildable object.
 */
@Deprecated public List<V1alpha1BindingCondition> getConditions(){
            return build(conditions);
    }

    public List<V1alpha1BindingCondition> buildConditions(){
            return build(conditions);
    }

    public V1alpha1BindingCondition buildCondition(int index){
            return this.conditions.get(index).build();
    }

    public V1alpha1BindingCondition buildFirstCondition(){
            return this.conditions.get(0).build();
    }

    public V1alpha1BindingCondition buildLastCondition(){
            return this.conditions.get(conditions.size() - 1).build();
    }

    public V1alpha1BindingCondition buildMatchingCondition(io.alauda.devops.java.client.fluent.Predicate<V1alpha1BindingConditionBuilder> predicate){
            for (V1alpha1BindingConditionBuilder item: conditions) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public Boolean hasMatchingCondition(io.alauda.devops.java.client.fluent.Predicate<V1alpha1BindingConditionBuilder> predicate){
            for (V1alpha1BindingConditionBuilder item: conditions) { if(predicate.apply(item)){return true;} } return false;
    }

    public A withConditions(List<V1alpha1BindingCondition> conditions){
            if (this.conditions != null) { _visitables.get("conditions").removeAll(this.conditions);}
            if (conditions != null) {this.conditions = new ArrayList<V1alpha1BindingConditionBuilder>(); for (V1alpha1BindingCondition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
    }

    public A withConditions(V1alpha1BindingCondition... conditions){
            if (this.conditions != null) {this.conditions.clear();}
            if (conditions != null) {for (V1alpha1BindingCondition item :conditions){ this.addToConditions(item);}} return (A) this;
    }

    public Boolean hasConditions(){
            return conditions != null && !conditions.isEmpty();
    }

    public V1alpha1JenkinsStatusFluent.ConditionsNested<A> addNewCondition(){
            return new ConditionsNestedImpl();
    }

    public V1alpha1JenkinsStatusFluent.ConditionsNested<A> addNewConditionLike(V1alpha1BindingCondition item){
            return new ConditionsNestedImpl(-1, item);
    }

    public V1alpha1JenkinsStatusFluent.ConditionsNested<A> setNewConditionLike(int index,V1alpha1BindingCondition item){
            return new ConditionsNestedImpl(index, item);
    }

    public V1alpha1JenkinsStatusFluent.ConditionsNested<A> editCondition(int index){
            if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
            return setNewConditionLike(index, buildCondition(index));
    }

    public V1alpha1JenkinsStatusFluent.ConditionsNested<A> editFirstCondition(){
            if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
            return setNewConditionLike(0, buildCondition(0));
    }

    public V1alpha1JenkinsStatusFluent.ConditionsNested<A> editLastCondition(){
            int index = conditions.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
            return setNewConditionLike(index, buildCondition(index));
    }

    public V1alpha1JenkinsStatusFluent.ConditionsNested<A> editMatchingCondition(io.alauda.devops.java.client.fluent.Predicate<V1alpha1BindingConditionBuilder> predicate){
            int index = -1;
            for (int i=0;i<conditions.size();i++) { 
            if (predicate.apply(conditions.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
            return setNewConditionLike(index, buildCondition(index));
    }

    
/**
 * This method has been deprecated, please use method buildHttp instead.
 * @return The buildable object.
 */
@Deprecated public V1alpha1HostPortStatus getHttp(){
            return this.http!=null?this.http.build():null;
    }

    public V1alpha1HostPortStatus buildHttp(){
            return this.http!=null?this.http.build():null;
    }

    public A withHttp(V1alpha1HostPortStatus http){
            _visitables.get("http").remove(this.http);
            if (http!=null){ this.http= new V1alpha1HostPortStatusBuilder(http); _visitables.get("http").add(this.http);} return (A) this;
    }

    public Boolean hasHttp(){
            return this.http != null;
    }

    public V1alpha1JenkinsStatusFluent.HttpNested<A> withNewHttp(){
            return new HttpNestedImpl();
    }

    public V1alpha1JenkinsStatusFluent.HttpNested<A> withNewHttpLike(V1alpha1HostPortStatus item){
            return new HttpNestedImpl(item);
    }

    public V1alpha1JenkinsStatusFluent.HttpNested<A> editHttp(){
            return withNewHttpLike(getHttp());
    }

    public V1alpha1JenkinsStatusFluent.HttpNested<A> editOrNewHttp(){
            return withNewHttpLike(getHttp() != null ? getHttp(): new V1alpha1HostPortStatusBuilder().build());
    }

    public V1alpha1JenkinsStatusFluent.HttpNested<A> editOrNewHttpLike(V1alpha1HostPortStatus item){
            return withNewHttpLike(getHttp() != null ? getHttp(): item);
    }

    public DateTime getLastUpdated(){
            return this.lastUpdated;
    }

    public A withLastUpdated(DateTime lastUpdated){
            this.lastUpdated=lastUpdated; return (A) this;
    }

    public Boolean hasLastUpdated(){
            return this.lastUpdated != null;
    }

    public A withNewLastUpdated(int arg0,int arg1,int arg2,int arg3,int arg4){
            return (A)withLastUpdated(new DateTime(arg0, arg1, arg2, arg3, arg4));
    }

    public A withNewLastUpdated(Object arg0){
            return (A)withLastUpdated(new DateTime(arg0));
    }

    public A withNewLastUpdated(long arg0){
            return (A)withLastUpdated(new DateTime(arg0));
    }

    public String getMessage(){
            return this.message;
    }

    public A withMessage(String message){
            this.message=message; return (A) this;
    }

    public Boolean hasMessage(){
            return this.message != null;
    }

    public A withNewMessage(String arg1){
            return (A)withMessage(new String(arg1));
    }

    public A withNewMessage(StringBuilder arg1){
            return (A)withMessage(new String(arg1));
    }

    public A withNewMessage(StringBuffer arg1){
            return (A)withMessage(new String(arg1));
    }

    public String getPhase(){
            return this.phase;
    }

    public A withPhase(String phase){
            this.phase=phase; return (A) this;
    }

    public Boolean hasPhase(){
            return this.phase != null;
    }

    public A withNewPhase(String arg1){
            return (A)withPhase(new String(arg1));
    }

    public A withNewPhase(StringBuilder arg1){
            return (A)withPhase(new String(arg1));
    }

    public A withNewPhase(StringBuffer arg1){
            return (A)withPhase(new String(arg1));
    }

    public String getReason(){
            return this.reason;
    }

    public A withReason(String reason){
            this.reason=reason; return (A) this;
    }

    public Boolean hasReason(){
            return this.reason != null;
    }

    public A withNewReason(String arg1){
            return (A)withReason(new String(arg1));
    }

    public A withNewReason(StringBuilder arg1){
            return (A)withReason(new String(arg1));
    }

    public A withNewReason(StringBuffer arg1){
            return (A)withReason(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1JenkinsStatusFluentImpl that = (V1alpha1JenkinsStatusFluentImpl) o;
            if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
            if (http != null ? !http.equals(that.http) :that.http != null) return false;
            if (lastUpdated != null ? !lastUpdated.equals(that.lastUpdated) :that.lastUpdated != null) return false;
            if (message != null ? !message.equals(that.message) :that.message != null) return false;
            if (phase != null ? !phase.equals(that.phase) :that.phase != null) return false;
            if (reason != null ? !reason.equals(that.reason) :that.reason != null) return false;
            return true;
    }


    public class ConditionsNestedImpl<N> extends V1alpha1BindingConditionFluentImpl<V1alpha1JenkinsStatusFluent.ConditionsNested<N>> implements V1alpha1JenkinsStatusFluent.ConditionsNested<N>,io.alauda.devops.java.client.fluent.Nested<N>{

            private final V1alpha1BindingConditionBuilder builder;
        private final int index;
    
            ConditionsNestedImpl(int index,V1alpha1BindingCondition item){
                    this.index = index;
                    this.builder = new V1alpha1BindingConditionBuilder(this, item);
            }
            ConditionsNestedImpl(){
                    this.index = -1;
                    this.builder = new V1alpha1BindingConditionBuilder(this);
            }
    
    public N and(){
            return (N) V1alpha1JenkinsStatusFluentImpl.this.setToConditions(index, builder.build());
    }
    public N endCondition(){
            return and();
    }

}
    public class HttpNestedImpl<N> extends V1alpha1HostPortStatusFluentImpl<V1alpha1JenkinsStatusFluent.HttpNested<N>> implements V1alpha1JenkinsStatusFluent.HttpNested<N>,io.alauda.devops.java.client.fluent.Nested<N>{

            private final V1alpha1HostPortStatusBuilder builder;
    
            HttpNestedImpl(V1alpha1HostPortStatus item){
                    this.builder = new V1alpha1HostPortStatusBuilder(this, item);
            }
            HttpNestedImpl(){
                    this.builder = new V1alpha1HostPortStatusBuilder(this);
            }
    
    public N and(){
            return (N) V1alpha1JenkinsStatusFluentImpl.this.withHttp(builder.build());
    }
    public N endHttp(){
            return and();
    }

}


}
