package io.alauda.devops.java.client.models;

import java.lang.StringBuilder;
import io.kubernetes.client.models.V1ObjectMeta;
import com.google.gson.annotations.SerializedName;
import io.alauda.devops.java.client.fluent.Nested;
import java.lang.String;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.alauda.devops.java.client.fluent.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1JenkinsFluentImpl<A extends V1alpha1JenkinsFluent<A>> extends io.alauda.devops.java.client.fluent.BaseFluent<A> implements V1alpha1JenkinsFluent<A>{

    private String apiVersion;
    private String kind;
    private V1ObjectMeta metadata;
    private V1alpha1JenkinsSpecBuilder spec;
    private V1alpha1JenkinsStatusBuilder status;

    public V1alpha1JenkinsFluentImpl(){
    }
    public V1alpha1JenkinsFluentImpl(V1alpha1Jenkins instance){
            this.withApiVersion(instance.getApiVersion());

            this.withKind(instance.getKind());

            this.withMetadata(instance.getMetadata());

            this.withSpec(instance.getSpec());

            this.withStatus(instance.getStatus());

    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion(){
            return this.apiVersion != null;
    }

    public A withNewApiVersion(String arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuilder arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuffer arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public Boolean hasKind(){
            return this.kind != null;
    }

    public A withNewKind(String arg1){
            return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuilder arg1){
            return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuffer arg1){
            return (A)withKind(new String(arg1));
    }

    public V1ObjectMeta getMetadata(){
            return this.metadata;
    }

    public A withMetadata(V1ObjectMeta metadata){
            this.metadata=metadata; return (A) this;
    }

    public Boolean hasMetadata(){
            return this.metadata != null;
    }

    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public V1alpha1JenkinsSpec getSpec(){
            return this.spec!=null?this.spec.build():null;
    }

    public V1alpha1JenkinsSpec buildSpec(){
            return this.spec!=null?this.spec.build():null;
    }

    public A withSpec(V1alpha1JenkinsSpec spec){
            _visitables.get("spec").remove(this.spec);
            if (spec!=null){ this.spec= new V1alpha1JenkinsSpecBuilder(spec); _visitables.get("spec").add(this.spec);} return (A) this;
    }

    public Boolean hasSpec(){
            return this.spec != null;
    }

    public V1alpha1JenkinsFluent.SpecNested<A> withNewSpec(){
            return new SpecNestedImpl();
    }

    public V1alpha1JenkinsFluent.SpecNested<A> withNewSpecLike(V1alpha1JenkinsSpec item){
            return new SpecNestedImpl(item);
    }

    public V1alpha1JenkinsFluent.SpecNested<A> editSpec(){
            return withNewSpecLike(getSpec());
    }

    public V1alpha1JenkinsFluent.SpecNested<A> editOrNewSpec(){
            return withNewSpecLike(getSpec() != null ? getSpec(): new V1alpha1JenkinsSpecBuilder().build());
    }

    public V1alpha1JenkinsFluent.SpecNested<A> editOrNewSpecLike(V1alpha1JenkinsSpec item){
            return withNewSpecLike(getSpec() != null ? getSpec(): item);
    }

    
/**
 * This method has been deprecated, please use method buildStatus instead.
 * @return The buildable object.
 */
@Deprecated public V1alpha1JenkinsStatus getStatus(){
            return this.status!=null?this.status.build():null;
    }

    public V1alpha1JenkinsStatus buildStatus(){
            return this.status!=null?this.status.build():null;
    }

    public A withStatus(V1alpha1JenkinsStatus status){
            _visitables.get("status").remove(this.status);
            if (status!=null){ this.status= new V1alpha1JenkinsStatusBuilder(status); _visitables.get("status").add(this.status);} return (A) this;
    }

    public Boolean hasStatus(){
            return this.status != null;
    }

    public V1alpha1JenkinsFluent.StatusNested<A> withNewStatus(){
            return new StatusNestedImpl();
    }

    public V1alpha1JenkinsFluent.StatusNested<A> withNewStatusLike(V1alpha1JenkinsStatus item){
            return new StatusNestedImpl(item);
    }

    public V1alpha1JenkinsFluent.StatusNested<A> editStatus(){
            return withNewStatusLike(getStatus());
    }

    public V1alpha1JenkinsFluent.StatusNested<A> editOrNewStatus(){
            return withNewStatusLike(getStatus() != null ? getStatus(): new V1alpha1JenkinsStatusBuilder().build());
    }

    public V1alpha1JenkinsFluent.StatusNested<A> editOrNewStatusLike(V1alpha1JenkinsStatus item){
            return withNewStatusLike(getStatus() != null ? getStatus(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1JenkinsFluentImpl that = (V1alpha1JenkinsFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
            if (spec != null ? !spec.equals(that.spec) :that.spec != null) return false;
            if (status != null ? !status.equals(that.status) :that.status != null) return false;
            return true;
    }


    public class SpecNestedImpl<N> extends V1alpha1JenkinsSpecFluentImpl<V1alpha1JenkinsFluent.SpecNested<N>> implements V1alpha1JenkinsFluent.SpecNested<N>,io.alauda.devops.java.client.fluent.Nested<N>{

            private final V1alpha1JenkinsSpecBuilder builder;
    
            SpecNestedImpl(V1alpha1JenkinsSpec item){
                    this.builder = new V1alpha1JenkinsSpecBuilder(this, item);
            }
            SpecNestedImpl(){
                    this.builder = new V1alpha1JenkinsSpecBuilder(this);
            }
    
    public N and(){
            return (N) V1alpha1JenkinsFluentImpl.this.withSpec(builder.build());
    }
    public N endSpec(){
            return and();
    }

}
    public class StatusNestedImpl<N> extends V1alpha1JenkinsStatusFluentImpl<V1alpha1JenkinsFluent.StatusNested<N>> implements V1alpha1JenkinsFluent.StatusNested<N>,io.alauda.devops.java.client.fluent.Nested<N>{

            private final V1alpha1JenkinsStatusBuilder builder;
    
            StatusNestedImpl(V1alpha1JenkinsStatus item){
                    this.builder = new V1alpha1JenkinsStatusBuilder(this, item);
            }
            StatusNestedImpl(){
                    this.builder = new V1alpha1JenkinsStatusBuilder(this);
            }
    
    public N and(){
            return (N) V1alpha1JenkinsFluentImpl.this.withStatus(builder.build());
    }
    public N endStatus(){
            return and();
    }

}


}
