package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1JenkinsBindingStatusBuilder extends V1alpha1JenkinsBindingStatusFluentImpl<V1alpha1JenkinsBindingStatusBuilder> implements VisitableBuilder<V1alpha1JenkinsBindingStatus,V1alpha1JenkinsBindingStatusBuilder>{

    V1alpha1JenkinsBindingStatusFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1JenkinsBindingStatusBuilder(){
            this(true);
    }
    public V1alpha1JenkinsBindingStatusBuilder(Boolean validationEnabled){
            this(new V1alpha1JenkinsBindingStatus(), validationEnabled);
    }
    public V1alpha1JenkinsBindingStatusBuilder(V1alpha1JenkinsBindingStatusFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1JenkinsBindingStatusBuilder(V1alpha1JenkinsBindingStatusFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1JenkinsBindingStatus(), validationEnabled);
    }
    public V1alpha1JenkinsBindingStatusBuilder(V1alpha1JenkinsBindingStatusFluent<?> fluent,V1alpha1JenkinsBindingStatus instance){
            this(fluent, instance, true);
    }
    public V1alpha1JenkinsBindingStatusBuilder(V1alpha1JenkinsBindingStatusFluent<?> fluent,V1alpha1JenkinsBindingStatus instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withConditions(instance.getConditions());

            fluent.withHttp(instance.getHttp());

            fluent.withLastUpdated(instance.getLastUpdated());

            fluent.withMessage(instance.getMessage());

            fluent.withPhase(instance.getPhase());

            fluent.withReason(instance.getReason());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1JenkinsBindingStatusBuilder(V1alpha1JenkinsBindingStatus instance){
            this(instance,true);
    }
    public V1alpha1JenkinsBindingStatusBuilder(V1alpha1JenkinsBindingStatus instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withConditions(instance.getConditions());

            this.withHttp(instance.getHttp());

            this.withLastUpdated(instance.getLastUpdated());

            this.withMessage(instance.getMessage());

            this.withPhase(instance.getPhase());

            this.withReason(instance.getReason());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1JenkinsBindingStatus build(){
            V1alpha1JenkinsBindingStatus buildable = new V1alpha1JenkinsBindingStatus();
            buildable.setConditions(fluent.getConditions());
            buildable.setHttp(fluent.getHttp());
            buildable.setLastUpdated(fluent.getLastUpdated());
            buildable.setMessage(fluent.getMessage());
            buildable.setPhase(fluent.getPhase());
            buildable.setReason(fluent.getReason());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1JenkinsBindingStatusBuilder that = (V1alpha1JenkinsBindingStatusBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
