package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1ImageRegistrySpecBuilder extends V1alpha1ImageRegistrySpecFluentImpl<V1alpha1ImageRegistrySpecBuilder> implements VisitableBuilder<V1alpha1ImageRegistrySpec,V1alpha1ImageRegistrySpecBuilder>{

    V1alpha1ImageRegistrySpecFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1ImageRegistrySpecBuilder(){
            this(true);
    }
    public V1alpha1ImageRegistrySpecBuilder(Boolean validationEnabled){
            this(new V1alpha1ImageRegistrySpec(), validationEnabled);
    }
    public V1alpha1ImageRegistrySpecBuilder(V1alpha1ImageRegistrySpecFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1ImageRegistrySpecBuilder(V1alpha1ImageRegistrySpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1ImageRegistrySpec(), validationEnabled);
    }
    public V1alpha1ImageRegistrySpecBuilder(V1alpha1ImageRegistrySpecFluent<?> fluent,V1alpha1ImageRegistrySpec instance){
            this(fluent, instance, true);
    }
    public V1alpha1ImageRegistrySpecBuilder(V1alpha1ImageRegistrySpecFluent<?> fluent,V1alpha1ImageRegistrySpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withBindingPolicy(instance.getBindingPolicy());

            fluent.withData(instance.getData());

            fluent.withHttp(instance.getHttp());

            fluent.withPublic(instance.isPublic());

            fluent.withSecret(instance.getSecret());

            fluent.withType(instance.getType());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1ImageRegistrySpecBuilder(V1alpha1ImageRegistrySpec instance){
            this(instance,true);
    }
    public V1alpha1ImageRegistrySpecBuilder(V1alpha1ImageRegistrySpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withBindingPolicy(instance.getBindingPolicy());

            this.withData(instance.getData());

            this.withHttp(instance.getHttp());

            this.withPublic(instance.isPublic());

            this.withSecret(instance.getSecret());

            this.withType(instance.getType());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1ImageRegistrySpec build(){
            V1alpha1ImageRegistrySpec buildable = new V1alpha1ImageRegistrySpec();
            buildable.setBindingPolicy(fluent.getBindingPolicy());
            buildable.setData(fluent.getData());
            buildable.setHttp(fluent.getHttp());
            buildable.setPublic(fluent.isPublic());
            buildable.setSecret(fluent.getSecret());
            buildable.setType(fluent.getType());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1ImageRegistrySpecBuilder that = (V1alpha1ImageRegistrySpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
