package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1ImageRegistryListBuilder extends V1alpha1ImageRegistryListFluentImpl<V1alpha1ImageRegistryListBuilder> implements VisitableBuilder<V1alpha1ImageRegistryList,V1alpha1ImageRegistryListBuilder>{

    V1alpha1ImageRegistryListFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1ImageRegistryListBuilder(){
            this(true);
    }
    public V1alpha1ImageRegistryListBuilder(Boolean validationEnabled){
            this(new V1alpha1ImageRegistryList(), validationEnabled);
    }
    public V1alpha1ImageRegistryListBuilder(V1alpha1ImageRegistryListFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1ImageRegistryListBuilder(V1alpha1ImageRegistryListFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1ImageRegistryList(), validationEnabled);
    }
    public V1alpha1ImageRegistryListBuilder(V1alpha1ImageRegistryListFluent<?> fluent,V1alpha1ImageRegistryList instance){
            this(fluent, instance, true);
    }
    public V1alpha1ImageRegistryListBuilder(V1alpha1ImageRegistryListFluent<?> fluent,V1alpha1ImageRegistryList instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion());

            fluent.withItems(instance.getItems());

            fluent.withKind(instance.getKind());

            fluent.withMetadata(instance.getMetadata());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1ImageRegistryListBuilder(V1alpha1ImageRegistryList instance){
            this(instance,true);
    }
    public V1alpha1ImageRegistryListBuilder(V1alpha1ImageRegistryList instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion());

            this.withItems(instance.getItems());

            this.withKind(instance.getKind());

            this.withMetadata(instance.getMetadata());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1ImageRegistryList build(){
            V1alpha1ImageRegistryList buildable = new V1alpha1ImageRegistryList();
            buildable.setApiVersion(fluent.getApiVersion());
            buildable.setItems(fluent.getItems());
            buildable.setKind(fluent.getKind());
            buildable.setMetadata(fluent.getMetadata());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1ImageRegistryListBuilder that = (V1alpha1ImageRegistryListBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
