package io.alauda.devops.java.client.models;

import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.lang.String;
import io.alauda.devops.java.client.fluent.Predicate;
import java.lang.StringBuffer;
import io.alauda.devops.java.client.fluent.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class V1alpha1ImageRegistryBindingRepositoriesFluentImpl<A extends V1alpha1ImageRegistryBindingRepositoriesFluent<A>> extends io.alauda.devops.java.client.fluent.BaseFluent<A> implements V1alpha1ImageRegistryBindingRepositoriesFluent<A>{

    private String apiVersion;
    private List<String> items;
    private String kind;

    public V1alpha1ImageRegistryBindingRepositoriesFluentImpl(){
    }
    public V1alpha1ImageRegistryBindingRepositoriesFluentImpl(V1alpha1ImageRegistryBindingRepositories instance){
            this.withApiVersion(instance.getApiVersion());

            this.withItems(instance.getItems());

            this.withKind(instance.getKind());

    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion(){
            return this.apiVersion != null;
    }

    public A withNewApiVersion(String arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuilder arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuffer arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A addToItems(int index,String item){
            if (this.items == null) {this.items = new ArrayList<String>();}
            this.items.add(index, item);
            return (A)this;
    }

    public A setToItems(int index,String item){
            if (this.items == null) {this.items = new ArrayList<String>();}
            this.items.set(index, item); return (A)this;
    }

    public A addToItems(String... items){
            if (this.items == null) {this.items = new ArrayList<String>();}
            for (String item : items) {this.items.add(item);} return (A)this;
    }

    public A addAllToItems(Collection<String> items){
            if (this.items == null) {this.items = new ArrayList<String>();}
            for (String item : items) {this.items.add(item);} return (A)this;
    }

    public A removeFromItems(String... items){
            for (String item : items) {if (this.items!= null){ this.items.remove(item);}} return (A)this;
    }

    public A removeAllFromItems(Collection<String> items){
            for (String item : items) {if (this.items!= null){ this.items.remove(item);}} return (A)this;
    }

    public List<String> getItems(){
            return this.items;
    }

    public String getItem(int index){
            return this.items.get(index);
    }

    public String getFirstItem(){
            return this.items.get(0);
    }

    public String getLastItem(){
            return this.items.get(items.size() - 1);
    }

    public String getMatchingItem(io.alauda.devops.java.client.fluent.Predicate<String> predicate){
            for (String item: items) { if(predicate.apply(item)){return item;} } return null;
    }

    public Boolean hasMatchingItem(io.alauda.devops.java.client.fluent.Predicate<String> predicate){
            for (String item: items) { if(predicate.apply(item)){return true;} } return false;
    }

    public A withItems(List<String> items){
            if (this.items != null) { _visitables.get("items").removeAll(this.items);}
            if (items != null) {this.items = new ArrayList<String>(); for (String item : items){this.addToItems(item);}} else { this.items = null;} return (A) this;
    }

    public A withItems(String... items){
            if (this.items != null) {this.items.clear();}
            if (items != null) {for (String item :items){ this.addToItems(item);}} return (A) this;
    }

    public Boolean hasItems(){
            return items != null && !items.isEmpty();
    }

    public A addNewItem(String arg1){
            return (A)addToItems(new String(arg1));
    }

    public A addNewItem(StringBuilder arg1){
            return (A)addToItems(new String(arg1));
    }

    public A addNewItem(StringBuffer arg1){
            return (A)addToItems(new String(arg1));
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public Boolean hasKind(){
            return this.kind != null;
    }

    public A withNewKind(String arg1){
            return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuilder arg1){
            return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuffer arg1){
            return (A)withKind(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1ImageRegistryBindingRepositoriesFluentImpl that = (V1alpha1ImageRegistryBindingRepositoriesFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (items != null ? !items.equals(that.items) :that.items != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            return true;
    }




}
