package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1ImageRegistryBindingPolicyBuilder extends V1alpha1ImageRegistryBindingPolicyFluentImpl<V1alpha1ImageRegistryBindingPolicyBuilder> implements VisitableBuilder<V1alpha1ImageRegistryBindingPolicy,V1alpha1ImageRegistryBindingPolicyBuilder>{

    V1alpha1ImageRegistryBindingPolicyFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1ImageRegistryBindingPolicyBuilder(){
            this(true);
    }
    public V1alpha1ImageRegistryBindingPolicyBuilder(Boolean validationEnabled){
            this(new V1alpha1ImageRegistryBindingPolicy(), validationEnabled);
    }
    public V1alpha1ImageRegistryBindingPolicyBuilder(V1alpha1ImageRegistryBindingPolicyFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1ImageRegistryBindingPolicyBuilder(V1alpha1ImageRegistryBindingPolicyFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1ImageRegistryBindingPolicy(), validationEnabled);
    }
    public V1alpha1ImageRegistryBindingPolicyBuilder(V1alpha1ImageRegistryBindingPolicyFluent<?> fluent,V1alpha1ImageRegistryBindingPolicy instance){
            this(fluent, instance, true);
    }
    public V1alpha1ImageRegistryBindingPolicyBuilder(V1alpha1ImageRegistryBindingPolicyFluent<?> fluent,V1alpha1ImageRegistryBindingPolicy instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withIndividual(instance.getIndividual());

            fluent.withShare(instance.getShare());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1ImageRegistryBindingPolicyBuilder(V1alpha1ImageRegistryBindingPolicy instance){
            this(instance,true);
    }
    public V1alpha1ImageRegistryBindingPolicyBuilder(V1alpha1ImageRegistryBindingPolicy instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withIndividual(instance.getIndividual());

            this.withShare(instance.getShare());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1ImageRegistryBindingPolicy build(){
            V1alpha1ImageRegistryBindingPolicy buildable = new V1alpha1ImageRegistryBindingPolicy();
            buildable.setIndividual(fluent.getIndividual());
            buildable.setShare(fluent.getShare());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1ImageRegistryBindingPolicyBuilder that = (V1alpha1ImageRegistryBindingPolicyBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
