package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1DownloadOptionBuilder extends V1alpha1DownloadOptionFluentImpl<V1alpha1DownloadOptionBuilder> implements VisitableBuilder<V1alpha1DownloadOption,V1alpha1DownloadOptionBuilder>{

    V1alpha1DownloadOptionFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1DownloadOptionBuilder(){
            this(true);
    }
    public V1alpha1DownloadOptionBuilder(Boolean validationEnabled){
            this(new V1alpha1DownloadOption(), validationEnabled);
    }
    public V1alpha1DownloadOptionBuilder(V1alpha1DownloadOptionFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1DownloadOptionBuilder(V1alpha1DownloadOptionFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1DownloadOption(), validationEnabled);
    }
    public V1alpha1DownloadOptionBuilder(V1alpha1DownloadOptionFluent<?> fluent,V1alpha1DownloadOption instance){
            this(fluent, instance, true);
    }
    public V1alpha1DownloadOptionBuilder(V1alpha1DownloadOptionFluent<?> fluent,V1alpha1DownloadOption instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAll(instance.isAll());

            fluent.withApiVersion(instance.getApiVersion());

            fluent.withFilename(instance.getFilename());

            fluent.withKind(instance.getKind());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1DownloadOptionBuilder(V1alpha1DownloadOption instance){
            this(instance,true);
    }
    public V1alpha1DownloadOptionBuilder(V1alpha1DownloadOption instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAll(instance.isAll());

            this.withApiVersion(instance.getApiVersion());

            this.withFilename(instance.getFilename());

            this.withKind(instance.getKind());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1DownloadOption build(){
            V1alpha1DownloadOption buildable = new V1alpha1DownloadOption();
            buildable.setAll(fluent.isAll());
            buildable.setApiVersion(fluent.getApiVersion());
            buildable.setFilename(fluent.getFilename());
            buildable.setKind(fluent.getKind());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1DownloadOptionBuilder that = (V1alpha1DownloadOptionBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
