package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1DocumentManagementBindingListBuilder extends V1alpha1DocumentManagementBindingListFluentImpl<V1alpha1DocumentManagementBindingListBuilder> implements VisitableBuilder<V1alpha1DocumentManagementBindingList,V1alpha1DocumentManagementBindingListBuilder>{

    V1alpha1DocumentManagementBindingListFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1DocumentManagementBindingListBuilder(){
            this(true);
    }
    public V1alpha1DocumentManagementBindingListBuilder(Boolean validationEnabled){
            this(new V1alpha1DocumentManagementBindingList(), validationEnabled);
    }
    public V1alpha1DocumentManagementBindingListBuilder(V1alpha1DocumentManagementBindingListFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1DocumentManagementBindingListBuilder(V1alpha1DocumentManagementBindingListFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1DocumentManagementBindingList(), validationEnabled);
    }
    public V1alpha1DocumentManagementBindingListBuilder(V1alpha1DocumentManagementBindingListFluent<?> fluent,V1alpha1DocumentManagementBindingList instance){
            this(fluent, instance, true);
    }
    public V1alpha1DocumentManagementBindingListBuilder(V1alpha1DocumentManagementBindingListFluent<?> fluent,V1alpha1DocumentManagementBindingList instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withListMeta(instance.getListMeta());

            fluent.withApiVersion(instance.getApiVersion());

            fluent.withItems(instance.getItems());

            fluent.withKind(instance.getKind());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1DocumentManagementBindingListBuilder(V1alpha1DocumentManagementBindingList instance){
            this(instance,true);
    }
    public V1alpha1DocumentManagementBindingListBuilder(V1alpha1DocumentManagementBindingList instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withListMeta(instance.getListMeta());

            this.withApiVersion(instance.getApiVersion());

            this.withItems(instance.getItems());

            this.withKind(instance.getKind());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1DocumentManagementBindingList build(){
            V1alpha1DocumentManagementBindingList buildable = new V1alpha1DocumentManagementBindingList();
            buildable.setListMeta(fluent.getListMeta());
            buildable.setApiVersion(fluent.getApiVersion());
            buildable.setItems(fluent.getItems());
            buildable.setKind(fluent.getKind());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1DocumentManagementBindingListBuilder that = (V1alpha1DocumentManagementBindingListBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
