package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1CreateProjectOptionsBuilder extends V1alpha1CreateProjectOptionsFluentImpl<V1alpha1CreateProjectOptionsBuilder> implements VisitableBuilder<V1alpha1CreateProjectOptions,V1alpha1CreateProjectOptionsBuilder>{

    V1alpha1CreateProjectOptionsFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1CreateProjectOptionsBuilder(){
            this(true);
    }
    public V1alpha1CreateProjectOptionsBuilder(Boolean validationEnabled){
            this(new V1alpha1CreateProjectOptions(), validationEnabled);
    }
    public V1alpha1CreateProjectOptionsBuilder(V1alpha1CreateProjectOptionsFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1CreateProjectOptionsBuilder(V1alpha1CreateProjectOptionsFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1CreateProjectOptions(), validationEnabled);
    }
    public V1alpha1CreateProjectOptionsBuilder(V1alpha1CreateProjectOptionsFluent<?> fluent,V1alpha1CreateProjectOptions instance){
            this(fluent, instance, true);
    }
    public V1alpha1CreateProjectOptionsBuilder(V1alpha1CreateProjectOptionsFluent<?> fluent,V1alpha1CreateProjectOptions instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion());

            fluent.withData(instance.getData());

            fluent.withIsRemote(instance.isIsRemote());

            fluent.withKind(instance.getKind());

            fluent.withMetadata(instance.getMetadata());

            fluent.withName(instance.getName());

            fluent.withNamespace(instance.getNamespace());

            fluent.withSecretname(instance.getSecretname());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1CreateProjectOptionsBuilder(V1alpha1CreateProjectOptions instance){
            this(instance,true);
    }
    public V1alpha1CreateProjectOptionsBuilder(V1alpha1CreateProjectOptions instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion());

            this.withData(instance.getData());

            this.withIsRemote(instance.isIsRemote());

            this.withKind(instance.getKind());

            this.withMetadata(instance.getMetadata());

            this.withName(instance.getName());

            this.withNamespace(instance.getNamespace());

            this.withSecretname(instance.getSecretname());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1CreateProjectOptions build(){
            V1alpha1CreateProjectOptions buildable = new V1alpha1CreateProjectOptions();
            buildable.setApiVersion(fluent.getApiVersion());
            buildable.setData(fluent.getData());
            buildable.setIsRemote(fluent.isIsRemote());
            buildable.setKind(fluent.getKind());
            buildable.setMetadata(fluent.getMetadata());
            buildable.setName(fluent.getName());
            buildable.setNamespace(fluent.getNamespace());
            buildable.setSecretname(fluent.getSecretname());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1CreateProjectOptionsBuilder that = (V1alpha1CreateProjectOptionsBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
