package io.alauda.devops.java.client.models;

import com.google.gson.annotations.SerializedName;
import io.alauda.devops.java.client.fluent.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;
import java.util.LinkedHashMap;

public class V1alpha1ConstValuesFluentImpl<A extends V1alpha1ConstValuesFluent<A>> extends io.alauda.devops.java.client.fluent.BaseFluent<A> implements V1alpha1ConstValuesFluent<A>{

    private Map<String,V1alpha1TaskConstValue> tasks;

    public V1alpha1ConstValuesFluentImpl(){
    }
    public V1alpha1ConstValuesFluentImpl(V1alpha1ConstValues instance){
            this.withTasks(instance.getTasks());

    }

    public A addToTasks(String key,V1alpha1TaskConstValue value){
            if(this.tasks == null && key != null && value != null) { this.tasks = new LinkedHashMap<String,V1alpha1TaskConstValue>(); }
            if(key != null && value != null) {this.tasks.put(key, value);} return (A)this;
    }

    public A addToTasks(Map<String,V1alpha1TaskConstValue> map){
            if(this.tasks == null && map != null) { this.tasks = new LinkedHashMap<String,V1alpha1TaskConstValue>(); }
            if(map != null) { this.tasks.putAll(map);} return (A)this;
    }

    public A removeFromTasks(String key){
            if(this.tasks == null) { return (A) this; }
            if(key != null && this.tasks != null) {this.tasks.remove(key);} return (A)this;
    }

    public A removeFromTasks(Map<String,V1alpha1TaskConstValue> map){
            if(this.tasks == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.tasks != null){this.tasks.remove(key);}}} return (A)this;
    }

    public Map<String,V1alpha1TaskConstValue> getTasks(){
            return this.tasks;
    }

    public A withTasks(Map<String,V1alpha1TaskConstValue> tasks){
            if (tasks == null) { this.tasks =  null;} else {this.tasks = new LinkedHashMap<String,V1alpha1TaskConstValue>(tasks);} return (A) this;
    }

    public Boolean hasTasks(){
            return this.tasks != null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1ConstValuesFluentImpl that = (V1alpha1ConstValuesFluentImpl) o;
            if (tasks != null ? !tasks.equals(that.tasks) :that.tasks != null) return false;
            return true;
    }




}
