package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1ConditionBuilder extends V1alpha1ConditionFluentImpl<V1alpha1ConditionBuilder> implements VisitableBuilder<V1alpha1Condition,V1alpha1ConditionBuilder>{

    V1alpha1ConditionFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1ConditionBuilder(){
            this(true);
    }
    public V1alpha1ConditionBuilder(Boolean validationEnabled){
            this(new V1alpha1Condition(), validationEnabled);
    }
    public V1alpha1ConditionBuilder(V1alpha1ConditionFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1ConditionBuilder(V1alpha1ConditionFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1Condition(), validationEnabled);
    }
    public V1alpha1ConditionBuilder(V1alpha1ConditionFluent<?> fluent,V1alpha1Condition instance){
            this(fluent, instance, true);
    }
    public V1alpha1ConditionBuilder(V1alpha1ConditionFluent<?> fluent,V1alpha1Condition instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withLastAttempt(instance.getLastAttempt());

            fluent.withMessage(instance.getMessage());

            fluent.withReason(instance.getReason());

            fluent.withStatus(instance.getStatus());

            fluent.withType(instance.getType());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1ConditionBuilder(V1alpha1Condition instance){
            this(instance,true);
    }
    public V1alpha1ConditionBuilder(V1alpha1Condition instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withLastAttempt(instance.getLastAttempt());

            this.withMessage(instance.getMessage());

            this.withReason(instance.getReason());

            this.withStatus(instance.getStatus());

            this.withType(instance.getType());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1Condition build(){
            V1alpha1Condition buildable = new V1alpha1Condition();
            buildable.setLastAttempt(fluent.getLastAttempt());
            buildable.setMessage(fluent.getMessage());
            buildable.setReason(fluent.getReason());
            buildable.setStatus(fluent.getStatus());
            buildable.setType(fluent.getType());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1ConditionBuilder that = (V1alpha1ConditionBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
