package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1CodeRepositorySpecBuilder extends V1alpha1CodeRepositorySpecFluentImpl<V1alpha1CodeRepositorySpecBuilder> implements VisitableBuilder<V1alpha1CodeRepositorySpec,V1alpha1CodeRepositorySpecBuilder>{

    V1alpha1CodeRepositorySpecFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1CodeRepositorySpecBuilder(){
            this(true);
    }
    public V1alpha1CodeRepositorySpecBuilder(Boolean validationEnabled){
            this(new V1alpha1CodeRepositorySpec(), validationEnabled);
    }
    public V1alpha1CodeRepositorySpecBuilder(V1alpha1CodeRepositorySpecFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1CodeRepositorySpecBuilder(V1alpha1CodeRepositorySpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1CodeRepositorySpec(), validationEnabled);
    }
    public V1alpha1CodeRepositorySpecBuilder(V1alpha1CodeRepositorySpecFluent<?> fluent,V1alpha1CodeRepositorySpec instance){
            this(fluent, instance, true);
    }
    public V1alpha1CodeRepositorySpecBuilder(V1alpha1CodeRepositorySpecFluent<?> fluent,V1alpha1CodeRepositorySpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withCodeRepoBinding(instance.getCodeRepoBinding());

            fluent.withRepository(instance.getRepository());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1CodeRepositorySpecBuilder(V1alpha1CodeRepositorySpec instance){
            this(instance,true);
    }
    public V1alpha1CodeRepositorySpecBuilder(V1alpha1CodeRepositorySpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withCodeRepoBinding(instance.getCodeRepoBinding());

            this.withRepository(instance.getRepository());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1CodeRepositorySpec build(){
            V1alpha1CodeRepositorySpec buildable = new V1alpha1CodeRepositorySpec();
            buildable.setCodeRepoBinding(fluent.getCodeRepoBinding());
            buildable.setRepository(fluent.getRepository());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1CodeRepositorySpecBuilder that = (V1alpha1CodeRepositorySpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
