package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1CodeRepositoryListBuilder extends V1alpha1CodeRepositoryListFluentImpl<V1alpha1CodeRepositoryListBuilder> implements VisitableBuilder<V1alpha1CodeRepositoryList,V1alpha1CodeRepositoryListBuilder>{

    V1alpha1CodeRepositoryListFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1CodeRepositoryListBuilder(){
            this(true);
    }
    public V1alpha1CodeRepositoryListBuilder(Boolean validationEnabled){
            this(new V1alpha1CodeRepositoryList(), validationEnabled);
    }
    public V1alpha1CodeRepositoryListBuilder(V1alpha1CodeRepositoryListFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1CodeRepositoryListBuilder(V1alpha1CodeRepositoryListFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1CodeRepositoryList(), validationEnabled);
    }
    public V1alpha1CodeRepositoryListBuilder(V1alpha1CodeRepositoryListFluent<?> fluent,V1alpha1CodeRepositoryList instance){
            this(fluent, instance, true);
    }
    public V1alpha1CodeRepositoryListBuilder(V1alpha1CodeRepositoryListFluent<?> fluent,V1alpha1CodeRepositoryList instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion());

            fluent.withItems(instance.getItems());

            fluent.withKind(instance.getKind());

            fluent.withMetadata(instance.getMetadata());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1CodeRepositoryListBuilder(V1alpha1CodeRepositoryList instance){
            this(instance,true);
    }
    public V1alpha1CodeRepositoryListBuilder(V1alpha1CodeRepositoryList instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion());

            this.withItems(instance.getItems());

            this.withKind(instance.getKind());

            this.withMetadata(instance.getMetadata());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1CodeRepositoryList build(){
            V1alpha1CodeRepositoryList buildable = new V1alpha1CodeRepositoryList();
            buildable.setApiVersion(fluent.getApiVersion());
            buildable.setItems(fluent.getItems());
            buildable.setKind(fluent.getKind());
            buildable.setMetadata(fluent.getMetadata());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1CodeRepositoryListBuilder that = (V1alpha1CodeRepositoryListBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
