package io.alauda.devops.java.client.models;

import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.alauda.devops.java.client.fluent.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.alauda.devops.java.client.fluent.Predicate;
import io.kubernetes.client.models.V1ListMeta;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.alauda.devops.java.client.fluent.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class V1alpha1CodeRepoBindingListFluentImpl<A extends V1alpha1CodeRepoBindingListFluent<A>> extends io.alauda.devops.java.client.fluent.BaseFluent<A> implements V1alpha1CodeRepoBindingListFluent<A>{

    private String apiVersion;
    private List<V1alpha1CodeRepoBindingBuilder> items;
    private String kind;
    private V1ListMeta metadata;

    public V1alpha1CodeRepoBindingListFluentImpl(){
    }
    public V1alpha1CodeRepoBindingListFluentImpl(V1alpha1CodeRepoBindingList instance){
            this.withApiVersion(instance.getApiVersion());

            this.withItems(instance.getItems());

            this.withKind(instance.getKind());

            this.withMetadata(instance.getMetadata());

    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion(){
            return this.apiVersion != null;
    }

    public A withNewApiVersion(String arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuilder arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuffer arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A addToItems(int index,V1alpha1CodeRepoBinding item){
            if (this.items == null) {this.items = new ArrayList<V1alpha1CodeRepoBindingBuilder>();}
            V1alpha1CodeRepoBindingBuilder builder = new V1alpha1CodeRepoBindingBuilder(item);_visitables.get("items").add(index >= 0 ? index : _visitables.get("items").size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
    }

    public A setToItems(int index,V1alpha1CodeRepoBinding item){
            if (this.items == null) {this.items = new ArrayList<V1alpha1CodeRepoBindingBuilder>();}
            V1alpha1CodeRepoBindingBuilder builder = new V1alpha1CodeRepoBindingBuilder(item);
            if (index < 0 || index >= _visitables.get("items").size()) { _visitables.get("items").add(builder); } else { _visitables.get("items").set(index, builder);}
            if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
             return (A)this;
    }

    public A addToItems(V1alpha1CodeRepoBinding... items){
            if (this.items == null) {this.items = new ArrayList<V1alpha1CodeRepoBindingBuilder>();}
            for (V1alpha1CodeRepoBinding item : items) {V1alpha1CodeRepoBindingBuilder builder = new V1alpha1CodeRepoBindingBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
    }

    public A addAllToItems(Collection<V1alpha1CodeRepoBinding> items){
            if (this.items == null) {this.items = new ArrayList<V1alpha1CodeRepoBindingBuilder>();}
            for (V1alpha1CodeRepoBinding item : items) {V1alpha1CodeRepoBindingBuilder builder = new V1alpha1CodeRepoBindingBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromItems(V1alpha1CodeRepoBinding... items){
            for (V1alpha1CodeRepoBinding item : items) {V1alpha1CodeRepoBindingBuilder builder = new V1alpha1CodeRepoBindingBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
    }

    public A removeAllFromItems(Collection<V1alpha1CodeRepoBinding> items){
            for (V1alpha1CodeRepoBinding item : items) {V1alpha1CodeRepoBindingBuilder builder = new V1alpha1CodeRepoBindingBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<V1alpha1CodeRepoBinding> getItems(){
            return build(items);
    }

    public List<V1alpha1CodeRepoBinding> buildItems(){
            return build(items);
    }

    public V1alpha1CodeRepoBinding buildItem(int index){
            return this.items.get(index).build();
    }

    public V1alpha1CodeRepoBinding buildFirstItem(){
            return this.items.get(0).build();
    }

    public V1alpha1CodeRepoBinding buildLastItem(){
            return this.items.get(items.size() - 1).build();
    }

    public V1alpha1CodeRepoBinding buildMatchingItem(io.alauda.devops.java.client.fluent.Predicate<V1alpha1CodeRepoBindingBuilder> predicate){
            for (V1alpha1CodeRepoBindingBuilder item: items) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public Boolean hasMatchingItem(io.alauda.devops.java.client.fluent.Predicate<V1alpha1CodeRepoBindingBuilder> predicate){
            for (V1alpha1CodeRepoBindingBuilder item: items) { if(predicate.apply(item)){return true;} } return false;
    }

    public A withItems(List<V1alpha1CodeRepoBinding> items){
            if (this.items != null) { _visitables.get("items").removeAll(this.items);}
            if (items != null) {this.items = new ArrayList<V1alpha1CodeRepoBindingBuilder>(); for (V1alpha1CodeRepoBinding item : items){this.addToItems(item);}} else { this.items = null;} return (A) this;
    }

    public A withItems(V1alpha1CodeRepoBinding... items){
            if (this.items != null) {this.items.clear();}
            if (items != null) {for (V1alpha1CodeRepoBinding item :items){ this.addToItems(item);}} return (A) this;
    }

    public Boolean hasItems(){
            return items != null && !items.isEmpty();
    }

    public V1alpha1CodeRepoBindingListFluent.ItemsNested<A> addNewItem(){
            return new ItemsNestedImpl();
    }

    public V1alpha1CodeRepoBindingListFluent.ItemsNested<A> addNewItemLike(V1alpha1CodeRepoBinding item){
            return new ItemsNestedImpl(-1, item);
    }

    public V1alpha1CodeRepoBindingListFluent.ItemsNested<A> setNewItemLike(int index,V1alpha1CodeRepoBinding item){
            return new ItemsNestedImpl(index, item);
    }

    public V1alpha1CodeRepoBindingListFluent.ItemsNested<A> editItem(int index){
            if (items.size() <= index) throw new RuntimeException("Can't edit items. Index exceeds size.");
            return setNewItemLike(index, buildItem(index));
    }

    public V1alpha1CodeRepoBindingListFluent.ItemsNested<A> editFirstItem(){
            if (items.size() == 0) throw new RuntimeException("Can't edit first items. The list is empty.");
            return setNewItemLike(0, buildItem(0));
    }

    public V1alpha1CodeRepoBindingListFluent.ItemsNested<A> editLastItem(){
            int index = items.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last items. The list is empty.");
            return setNewItemLike(index, buildItem(index));
    }

    public V1alpha1CodeRepoBindingListFluent.ItemsNested<A> editMatchingItem(io.alauda.devops.java.client.fluent.Predicate<V1alpha1CodeRepoBindingBuilder> predicate){
            int index = -1;
            for (int i=0;i<items.size();i++) { 
            if (predicate.apply(items.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching items. No match found.");
            return setNewItemLike(index, buildItem(index));
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public Boolean hasKind(){
            return this.kind != null;
    }

    public A withNewKind(String arg1){
            return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuilder arg1){
            return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuffer arg1){
            return (A)withKind(new String(arg1));
    }

    public V1ListMeta getMetadata(){
            return this.metadata;
    }

    public A withMetadata(V1ListMeta metadata){
            this.metadata=metadata; return (A) this;
    }

    public Boolean hasMetadata(){
            return this.metadata != null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1CodeRepoBindingListFluentImpl that = (V1alpha1CodeRepoBindingListFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (items != null ? !items.equals(that.items) :that.items != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
            return true;
    }


    public class ItemsNestedImpl<N> extends V1alpha1CodeRepoBindingFluentImpl<V1alpha1CodeRepoBindingListFluent.ItemsNested<N>> implements V1alpha1CodeRepoBindingListFluent.ItemsNested<N>,io.alauda.devops.java.client.fluent.Nested<N>{

            private final V1alpha1CodeRepoBindingBuilder builder;
        private final int index;
    
            ItemsNestedImpl(int index,V1alpha1CodeRepoBinding item){
                    this.index = index;
                    this.builder = new V1alpha1CodeRepoBindingBuilder(this, item);
            }
            ItemsNestedImpl(){
                    this.index = -1;
                    this.builder = new V1alpha1CodeRepoBindingBuilder(this);
            }
    
    public N and(){
            return (N) V1alpha1CodeRepoBindingListFluentImpl.this.setToItems(index, builder.build());
    }
    public N endItem(){
            return and();
    }

}


}
