package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1CodeQualityBindingSpecBuilder extends V1alpha1CodeQualityBindingSpecFluentImpl<V1alpha1CodeQualityBindingSpecBuilder> implements VisitableBuilder<V1alpha1CodeQualityBindingSpec,V1alpha1CodeQualityBindingSpecBuilder>{

    V1alpha1CodeQualityBindingSpecFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1CodeQualityBindingSpecBuilder(){
            this(true);
    }
    public V1alpha1CodeQualityBindingSpecBuilder(Boolean validationEnabled){
            this(new V1alpha1CodeQualityBindingSpec(), validationEnabled);
    }
    public V1alpha1CodeQualityBindingSpecBuilder(V1alpha1CodeQualityBindingSpecFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1CodeQualityBindingSpecBuilder(V1alpha1CodeQualityBindingSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1CodeQualityBindingSpec(), validationEnabled);
    }
    public V1alpha1CodeQualityBindingSpecBuilder(V1alpha1CodeQualityBindingSpecFluent<?> fluent,V1alpha1CodeQualityBindingSpec instance){
            this(fluent, instance, true);
    }
    public V1alpha1CodeQualityBindingSpecBuilder(V1alpha1CodeQualityBindingSpecFluent<?> fluent,V1alpha1CodeQualityBindingSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withCodeQualityTool(instance.getCodeQualityTool());

            fluent.withCodeRepository(instance.getCodeRepository());

            fluent.withPattern(instance.getPattern());

            fluent.withSecret(instance.getSecret());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1CodeQualityBindingSpecBuilder(V1alpha1CodeQualityBindingSpec instance){
            this(instance,true);
    }
    public V1alpha1CodeQualityBindingSpecBuilder(V1alpha1CodeQualityBindingSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withCodeQualityTool(instance.getCodeQualityTool());

            this.withCodeRepository(instance.getCodeRepository());

            this.withPattern(instance.getPattern());

            this.withSecret(instance.getSecret());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1CodeQualityBindingSpec build(){
            V1alpha1CodeQualityBindingSpec buildable = new V1alpha1CodeQualityBindingSpec();
            buildable.setCodeQualityTool(fluent.getCodeQualityTool());
            buildable.setCodeRepository(fluent.getCodeRepository());
            buildable.setPattern(fluent.getPattern());
            buildable.setSecret(fluent.getSecret());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1CodeQualityBindingSpecBuilder that = (V1alpha1CodeQualityBindingSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
