package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1CodeQualityBindingReplicaTemplateBuilder extends V1alpha1CodeQualityBindingReplicaTemplateFluentImpl<V1alpha1CodeQualityBindingReplicaTemplateBuilder> implements VisitableBuilder<V1alpha1CodeQualityBindingReplicaTemplate,V1alpha1CodeQualityBindingReplicaTemplateBuilder>{

    V1alpha1CodeQualityBindingReplicaTemplateFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1CodeQualityBindingReplicaTemplateBuilder(){
            this(true);
    }
    public V1alpha1CodeQualityBindingReplicaTemplateBuilder(Boolean validationEnabled){
            this(new V1alpha1CodeQualityBindingReplicaTemplate(), validationEnabled);
    }
    public V1alpha1CodeQualityBindingReplicaTemplateBuilder(V1alpha1CodeQualityBindingReplicaTemplateFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1CodeQualityBindingReplicaTemplateBuilder(V1alpha1CodeQualityBindingReplicaTemplateFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1CodeQualityBindingReplicaTemplate(), validationEnabled);
    }
    public V1alpha1CodeQualityBindingReplicaTemplateBuilder(V1alpha1CodeQualityBindingReplicaTemplateFluent<?> fluent,V1alpha1CodeQualityBindingReplicaTemplate instance){
            this(fluent, instance, true);
    }
    public V1alpha1CodeQualityBindingReplicaTemplateBuilder(V1alpha1CodeQualityBindingReplicaTemplateFluent<?> fluent,V1alpha1CodeQualityBindingReplicaTemplate instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withTemplate(instance.getTemplate());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1CodeQualityBindingReplicaTemplateBuilder(V1alpha1CodeQualityBindingReplicaTemplate instance){
            this(instance,true);
    }
    public V1alpha1CodeQualityBindingReplicaTemplateBuilder(V1alpha1CodeQualityBindingReplicaTemplate instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withTemplate(instance.getTemplate());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1CodeQualityBindingReplicaTemplate build(){
            V1alpha1CodeQualityBindingReplicaTemplate buildable = new V1alpha1CodeQualityBindingReplicaTemplate();
            buildable.setTemplate(fluent.getTemplate());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1CodeQualityBindingReplicaTemplateBuilder that = (V1alpha1CodeQualityBindingReplicaTemplateBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
