package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1ClusterPipelineTemplateSyncBuilder extends V1alpha1ClusterPipelineTemplateSyncFluentImpl<V1alpha1ClusterPipelineTemplateSyncBuilder> implements VisitableBuilder<V1alpha1ClusterPipelineTemplateSync,V1alpha1ClusterPipelineTemplateSyncBuilder>{

    V1alpha1ClusterPipelineTemplateSyncFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1ClusterPipelineTemplateSyncBuilder(){
            this(true);
    }
    public V1alpha1ClusterPipelineTemplateSyncBuilder(Boolean validationEnabled){
            this(new V1alpha1ClusterPipelineTemplateSync(), validationEnabled);
    }
    public V1alpha1ClusterPipelineTemplateSyncBuilder(V1alpha1ClusterPipelineTemplateSyncFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1ClusterPipelineTemplateSyncBuilder(V1alpha1ClusterPipelineTemplateSyncFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1ClusterPipelineTemplateSync(), validationEnabled);
    }
    public V1alpha1ClusterPipelineTemplateSyncBuilder(V1alpha1ClusterPipelineTemplateSyncFluent<?> fluent,V1alpha1ClusterPipelineTemplateSync instance){
            this(fluent, instance, true);
    }
    public V1alpha1ClusterPipelineTemplateSyncBuilder(V1alpha1ClusterPipelineTemplateSyncFluent<?> fluent,V1alpha1ClusterPipelineTemplateSync instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion());

            fluent.withKind(instance.getKind());

            fluent.withMetadata(instance.getMetadata());

            fluent.withSpec(instance.getSpec());

            fluent.withStatus(instance.getStatus());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1ClusterPipelineTemplateSyncBuilder(V1alpha1ClusterPipelineTemplateSync instance){
            this(instance,true);
    }
    public V1alpha1ClusterPipelineTemplateSyncBuilder(V1alpha1ClusterPipelineTemplateSync instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion());

            this.withKind(instance.getKind());

            this.withMetadata(instance.getMetadata());

            this.withSpec(instance.getSpec());

            this.withStatus(instance.getStatus());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1ClusterPipelineTemplateSync build(){
            V1alpha1ClusterPipelineTemplateSync buildable = new V1alpha1ClusterPipelineTemplateSync();
            buildable.setApiVersion(fluent.getApiVersion());
            buildable.setKind(fluent.getKind());
            buildable.setMetadata(fluent.getMetadata());
            buildable.setSpec(fluent.getSpec());
            buildable.setStatus(fluent.getStatus());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1ClusterPipelineTemplateSyncBuilder that = (V1alpha1ClusterPipelineTemplateSyncBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
