package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1ClusterPipelineTaskTemplateBuilder extends V1alpha1ClusterPipelineTaskTemplateFluentImpl<V1alpha1ClusterPipelineTaskTemplateBuilder> implements VisitableBuilder<V1alpha1ClusterPipelineTaskTemplate,V1alpha1ClusterPipelineTaskTemplateBuilder>{

    V1alpha1ClusterPipelineTaskTemplateFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1ClusterPipelineTaskTemplateBuilder(){
            this(true);
    }
    public V1alpha1ClusterPipelineTaskTemplateBuilder(Boolean validationEnabled){
            this(new V1alpha1ClusterPipelineTaskTemplate(), validationEnabled);
    }
    public V1alpha1ClusterPipelineTaskTemplateBuilder(V1alpha1ClusterPipelineTaskTemplateFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1ClusterPipelineTaskTemplateBuilder(V1alpha1ClusterPipelineTaskTemplateFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1ClusterPipelineTaskTemplate(), validationEnabled);
    }
    public V1alpha1ClusterPipelineTaskTemplateBuilder(V1alpha1ClusterPipelineTaskTemplateFluent<?> fluent,V1alpha1ClusterPipelineTaskTemplate instance){
            this(fluent, instance, true);
    }
    public V1alpha1ClusterPipelineTaskTemplateBuilder(V1alpha1ClusterPipelineTaskTemplateFluent<?> fluent,V1alpha1ClusterPipelineTaskTemplate instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion());

            fluent.withKind(instance.getKind());

            fluent.withMetadata(instance.getMetadata());

            fluent.withSpec(instance.getSpec());

            fluent.withStatus(instance.getStatus());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1ClusterPipelineTaskTemplateBuilder(V1alpha1ClusterPipelineTaskTemplate instance){
            this(instance,true);
    }
    public V1alpha1ClusterPipelineTaskTemplateBuilder(V1alpha1ClusterPipelineTaskTemplate instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion());

            this.withKind(instance.getKind());

            this.withMetadata(instance.getMetadata());

            this.withSpec(instance.getSpec());

            this.withStatus(instance.getStatus());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1ClusterPipelineTaskTemplate build(){
            V1alpha1ClusterPipelineTaskTemplate buildable = new V1alpha1ClusterPipelineTaskTemplate();
            buildable.setApiVersion(fluent.getApiVersion());
            buildable.setKind(fluent.getKind());
            buildable.setMetadata(fluent.getMetadata());
            buildable.setSpec(fluent.getSpec());
            buildable.setStatus(fluent.getStatus());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1ClusterPipelineTaskTemplateBuilder that = (V1alpha1ClusterPipelineTaskTemplateBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
