package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1BindingConditionBuilder extends V1alpha1BindingConditionFluentImpl<V1alpha1BindingConditionBuilder> implements VisitableBuilder<V1alpha1BindingCondition,V1alpha1BindingConditionBuilder>{

    V1alpha1BindingConditionFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1BindingConditionBuilder(){
            this(true);
    }
    public V1alpha1BindingConditionBuilder(Boolean validationEnabled){
            this(new V1alpha1BindingCondition(), validationEnabled);
    }
    public V1alpha1BindingConditionBuilder(V1alpha1BindingConditionFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1BindingConditionBuilder(V1alpha1BindingConditionFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1BindingCondition(), validationEnabled);
    }
    public V1alpha1BindingConditionBuilder(V1alpha1BindingConditionFluent<?> fluent,V1alpha1BindingCondition instance){
            this(fluent, instance, true);
    }
    public V1alpha1BindingConditionBuilder(V1alpha1BindingConditionFluent<?> fluent,V1alpha1BindingCondition instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withLastAttempt(instance.getLastAttempt());

            fluent.withMessage(instance.getMessage());

            fluent.withName(instance.getName());

            fluent.withNamespace(instance.getNamespace());

            fluent.withOwner(instance.getOwner());

            fluent.withReason(instance.getReason());

            fluent.withStatus(instance.getStatus());

            fluent.withType(instance.getType());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1BindingConditionBuilder(V1alpha1BindingCondition instance){
            this(instance,true);
    }
    public V1alpha1BindingConditionBuilder(V1alpha1BindingCondition instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withLastAttempt(instance.getLastAttempt());

            this.withMessage(instance.getMessage());

            this.withName(instance.getName());

            this.withNamespace(instance.getNamespace());

            this.withOwner(instance.getOwner());

            this.withReason(instance.getReason());

            this.withStatus(instance.getStatus());

            this.withType(instance.getType());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1BindingCondition build(){
            V1alpha1BindingCondition buildable = new V1alpha1BindingCondition();
            buildable.setLastAttempt(fluent.getLastAttempt());
            buildable.setMessage(fluent.getMessage());
            buildable.setName(fluent.getName());
            buildable.setNamespace(fluent.getNamespace());
            buildable.setOwner(fluent.getOwner());
            buildable.setReason(fluent.getReason());
            buildable.setStatus(fluent.getStatus());
            buildable.setType(fluent.getType());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1BindingConditionBuilder that = (V1alpha1BindingConditionBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
