package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1ArtifactRegistryManagerSpecBuilder extends V1alpha1ArtifactRegistryManagerSpecFluentImpl<V1alpha1ArtifactRegistryManagerSpecBuilder> implements VisitableBuilder<V1alpha1ArtifactRegistryManagerSpec,V1alpha1ArtifactRegistryManagerSpecBuilder>{

    V1alpha1ArtifactRegistryManagerSpecFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1ArtifactRegistryManagerSpecBuilder(){
            this(true);
    }
    public V1alpha1ArtifactRegistryManagerSpecBuilder(Boolean validationEnabled){
            this(new V1alpha1ArtifactRegistryManagerSpec(), validationEnabled);
    }
    public V1alpha1ArtifactRegistryManagerSpecBuilder(V1alpha1ArtifactRegistryManagerSpecFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1ArtifactRegistryManagerSpecBuilder(V1alpha1ArtifactRegistryManagerSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1ArtifactRegistryManagerSpec(), validationEnabled);
    }
    public V1alpha1ArtifactRegistryManagerSpecBuilder(V1alpha1ArtifactRegistryManagerSpecFluent<?> fluent,V1alpha1ArtifactRegistryManagerSpec instance){
            this(fluent, instance, true);
    }
    public V1alpha1ArtifactRegistryManagerSpecBuilder(V1alpha1ArtifactRegistryManagerSpecFluent<?> fluent,V1alpha1ArtifactRegistryManagerSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withHttp(instance.getHttp());

            fluent.withSecret(instance.getSecret());

            fluent.withType(instance.getType());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1ArtifactRegistryManagerSpecBuilder(V1alpha1ArtifactRegistryManagerSpec instance){
            this(instance,true);
    }
    public V1alpha1ArtifactRegistryManagerSpecBuilder(V1alpha1ArtifactRegistryManagerSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withHttp(instance.getHttp());

            this.withSecret(instance.getSecret());

            this.withType(instance.getType());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1ArtifactRegistryManagerSpec build(){
            V1alpha1ArtifactRegistryManagerSpec buildable = new V1alpha1ArtifactRegistryManagerSpec();
            buildable.setHttp(fluent.getHttp());
            buildable.setSecret(fluent.getSecret());
            buildable.setType(fluent.getType());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1ArtifactRegistryManagerSpecBuilder that = (V1alpha1ArtifactRegistryManagerSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
