package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1ArtifactRegistryBindingSpecBuilder extends V1alpha1ArtifactRegistryBindingSpecFluentImpl<V1alpha1ArtifactRegistryBindingSpecBuilder> implements VisitableBuilder<V1alpha1ArtifactRegistryBindingSpec,V1alpha1ArtifactRegistryBindingSpecBuilder>{

    V1alpha1ArtifactRegistryBindingSpecFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1ArtifactRegistryBindingSpecBuilder(){
            this(true);
    }
    public V1alpha1ArtifactRegistryBindingSpecBuilder(Boolean validationEnabled){
            this(new V1alpha1ArtifactRegistryBindingSpec(), validationEnabled);
    }
    public V1alpha1ArtifactRegistryBindingSpecBuilder(V1alpha1ArtifactRegistryBindingSpecFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1ArtifactRegistryBindingSpecBuilder(V1alpha1ArtifactRegistryBindingSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1ArtifactRegistryBindingSpec(), validationEnabled);
    }
    public V1alpha1ArtifactRegistryBindingSpecBuilder(V1alpha1ArtifactRegistryBindingSpecFluent<?> fluent,V1alpha1ArtifactRegistryBindingSpec instance){
            this(fluent, instance, true);
    }
    public V1alpha1ArtifactRegistryBindingSpecBuilder(V1alpha1ArtifactRegistryBindingSpecFluent<?> fluent,V1alpha1ArtifactRegistryBindingSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withArtifactRegistry(instance.getArtifactRegistry());

            fluent.withSecret(instance.getSecret());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1ArtifactRegistryBindingSpecBuilder(V1alpha1ArtifactRegistryBindingSpec instance){
            this(instance,true);
    }
    public V1alpha1ArtifactRegistryBindingSpecBuilder(V1alpha1ArtifactRegistryBindingSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withArtifactRegistry(instance.getArtifactRegistry());

            this.withSecret(instance.getSecret());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1ArtifactRegistryBindingSpec build(){
            V1alpha1ArtifactRegistryBindingSpec buildable = new V1alpha1ArtifactRegistryBindingSpec();
            buildable.setArtifactRegistry(fluent.getArtifactRegistry());
            buildable.setSecret(fluent.getSecret());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1ArtifactRegistryBindingSpecBuilder that = (V1alpha1ArtifactRegistryBindingSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
