package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1PipelineTemplateArgumentGroupBuilder extends V1alpha1PipelineTemplateArgumentGroupFluentImpl<V1alpha1PipelineTemplateArgumentGroupBuilder> implements VisitableBuilder<V1alpha1PipelineTemplateArgumentGroup,V1alpha1PipelineTemplateArgumentGroupBuilder>{

    V1alpha1PipelineTemplateArgumentGroupFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1PipelineTemplateArgumentGroupBuilder(){
            this(true);
    }
    public V1alpha1PipelineTemplateArgumentGroupBuilder(Boolean validationEnabled){
            this(new V1alpha1PipelineTemplateArgumentGroup(), validationEnabled);
    }
    public V1alpha1PipelineTemplateArgumentGroupBuilder(V1alpha1PipelineTemplateArgumentGroupFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1PipelineTemplateArgumentGroupBuilder(V1alpha1PipelineTemplateArgumentGroupFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1PipelineTemplateArgumentGroup(), validationEnabled);
    }
    public V1alpha1PipelineTemplateArgumentGroupBuilder(V1alpha1PipelineTemplateArgumentGroupFluent<?> fluent,V1alpha1PipelineTemplateArgumentGroup instance){
            this(fluent, instance, true);
    }
    public V1alpha1PipelineTemplateArgumentGroupBuilder(V1alpha1PipelineTemplateArgumentGroupFluent<?> fluent,V1alpha1PipelineTemplateArgumentGroup instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withDisplayName(instance.getDisplayName());

            fluent.withItems(instance.getItems());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1PipelineTemplateArgumentGroupBuilder(V1alpha1PipelineTemplateArgumentGroup instance){
            this(instance,true);
    }
    public V1alpha1PipelineTemplateArgumentGroupBuilder(V1alpha1PipelineTemplateArgumentGroup instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withDisplayName(instance.getDisplayName());

            this.withItems(instance.getItems());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1PipelineTemplateArgumentGroup build(){
            V1alpha1PipelineTemplateArgumentGroup buildable = new V1alpha1PipelineTemplateArgumentGroup();
            buildable.setDisplayName(fluent.getDisplayName());
            buildable.setItems(fluent.getItems());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1PipelineTemplateArgumentGroupBuilder that = (V1alpha1PipelineTemplateArgumentGroupBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
