package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1PipelineStatusInfoItemBuilder extends V1alpha1PipelineStatusInfoItemFluentImpl<V1alpha1PipelineStatusInfoItemBuilder> implements VisitableBuilder<V1alpha1PipelineStatusInfoItem,V1alpha1PipelineStatusInfoItemBuilder>{

    V1alpha1PipelineStatusInfoItemFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1PipelineStatusInfoItemBuilder(){
            this(true);
    }
    public V1alpha1PipelineStatusInfoItemBuilder(Boolean validationEnabled){
            this(new V1alpha1PipelineStatusInfoItem(), validationEnabled);
    }
    public V1alpha1PipelineStatusInfoItemBuilder(V1alpha1PipelineStatusInfoItemFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1PipelineStatusInfoItemBuilder(V1alpha1PipelineStatusInfoItemFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1PipelineStatusInfoItem(), validationEnabled);
    }
    public V1alpha1PipelineStatusInfoItemBuilder(V1alpha1PipelineStatusInfoItemFluent<?> fluent,V1alpha1PipelineStatusInfoItem instance){
            this(fluent, instance, true);
    }
    public V1alpha1PipelineStatusInfoItemBuilder(V1alpha1PipelineStatusInfoItemFluent<?> fluent,V1alpha1PipelineStatusInfoItem instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withDescription(instance.getDescription());

            fluent.withName(instance.getName());

            fluent.withType(instance.getType());

            fluent.withValue(instance.getValue());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1PipelineStatusInfoItemBuilder(V1alpha1PipelineStatusInfoItem instance){
            this(instance,true);
    }
    public V1alpha1PipelineStatusInfoItemBuilder(V1alpha1PipelineStatusInfoItem instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withDescription(instance.getDescription());

            this.withName(instance.getName());

            this.withType(instance.getType());

            this.withValue(instance.getValue());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1PipelineStatusInfoItem build(){
            V1alpha1PipelineStatusInfoItem buildable = new V1alpha1PipelineStatusInfoItem();
            buildable.setDescription(fluent.getDescription());
            buildable.setName(fluent.getName());
            buildable.setType(fluent.getType());
            buildable.setValue(fluent.getValue());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1PipelineStatusInfoItemBuilder that = (V1alpha1PipelineStatusInfoItemBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
