package io.alauda.devops.java.client.models;

import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.alauda.devops.java.client.fluent.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.alauda.devops.java.client.fluent.Predicate;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.alauda.devops.java.client.fluent.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public class V1alpha1PipelineStageFluentImpl<A extends V1alpha1PipelineStageFluent<A>> extends io.alauda.devops.java.client.fluent.BaseFluent<A> implements V1alpha1PipelineStageFluent<A>{

    private Map<String,List<String>> conditions;
    private V1alpha1I18nNameBuilder display;
    private String name;
    private List<V1alpha1PipelineTemplateTaskBuilder> tasks;

    public V1alpha1PipelineStageFluentImpl(){
    }
    public V1alpha1PipelineStageFluentImpl(V1alpha1PipelineStage instance){
            this.withConditions(instance.getConditions());

            this.withDisplay(instance.getDisplay());

            this.withName(instance.getName());

            this.withTasks(instance.getTasks());

    }

    public A addToConditions(String key,List<String> value){
            if(this.conditions == null && key != null && value != null) { this.conditions = new LinkedHashMap<String,List<String>>(); }
            if(key != null && value != null) {this.conditions.put(key, value);} return (A)this;
    }

    public A addToConditions(Map<String,List<String>> map){
            if(this.conditions == null && map != null) { this.conditions = new LinkedHashMap<String,List<String>>(); }
            if(map != null) { this.conditions.putAll(map);} return (A)this;
    }

    public A removeFromConditions(String key){
            if(this.conditions == null) { return (A) this; }
            if(key != null && this.conditions != null) {this.conditions.remove(key);} return (A)this;
    }

    public A removeFromConditions(Map<String,List<String>> map){
            if(this.conditions == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.conditions != null){this.conditions.remove(key);}}} return (A)this;
    }

    public Map<String,List<String>> getConditions(){
            return this.conditions;
    }

    public A withConditions(Map<String,List<String>> conditions){
            if (conditions == null) { this.conditions =  null;} else {this.conditions = new LinkedHashMap<String,List<String>>(conditions);} return (A) this;
    }

    public Boolean hasConditions(){
            return this.conditions != null;
    }

    
/**
 * This method has been deprecated, please use method buildDisplay instead.
 * @return The buildable object.
 */
@Deprecated public V1alpha1I18nName getDisplay(){
            return this.display!=null?this.display.build():null;
    }

    public V1alpha1I18nName buildDisplay(){
            return this.display!=null?this.display.build():null;
    }

    public A withDisplay(V1alpha1I18nName display){
            _visitables.get("display").remove(this.display);
            if (display!=null){ this.display= new V1alpha1I18nNameBuilder(display); _visitables.get("display").add(this.display);} return (A) this;
    }

    public Boolean hasDisplay(){
            return this.display != null;
    }

    public V1alpha1PipelineStageFluent.DisplayNested<A> withNewDisplay(){
            return new DisplayNestedImpl();
    }

    public V1alpha1PipelineStageFluent.DisplayNested<A> withNewDisplayLike(V1alpha1I18nName item){
            return new DisplayNestedImpl(item);
    }

    public V1alpha1PipelineStageFluent.DisplayNested<A> editDisplay(){
            return withNewDisplayLike(getDisplay());
    }

    public V1alpha1PipelineStageFluent.DisplayNested<A> editOrNewDisplay(){
            return withNewDisplayLike(getDisplay() != null ? getDisplay(): new V1alpha1I18nNameBuilder().build());
    }

    public V1alpha1PipelineStageFluent.DisplayNested<A> editOrNewDisplayLike(V1alpha1I18nName item){
            return withNewDisplayLike(getDisplay() != null ? getDisplay(): item);
    }

    public String getName(){
            return this.name;
    }

    public A withName(String name){
            this.name=name; return (A) this;
    }

    public Boolean hasName(){
            return this.name != null;
    }

    public A withNewName(String arg1){
            return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuilder arg1){
            return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuffer arg1){
            return (A)withName(new String(arg1));
    }

    public A addToTasks(int index,V1alpha1PipelineTemplateTask item){
            if (this.tasks == null) {this.tasks = new ArrayList<V1alpha1PipelineTemplateTaskBuilder>();}
            V1alpha1PipelineTemplateTaskBuilder builder = new V1alpha1PipelineTemplateTaskBuilder(item);_visitables.get("tasks").add(index >= 0 ? index : _visitables.get("tasks").size(), builder);this.tasks.add(index >= 0 ? index : tasks.size(), builder); return (A)this;
    }

    public A setToTasks(int index,V1alpha1PipelineTemplateTask item){
            if (this.tasks == null) {this.tasks = new ArrayList<V1alpha1PipelineTemplateTaskBuilder>();}
            V1alpha1PipelineTemplateTaskBuilder builder = new V1alpha1PipelineTemplateTaskBuilder(item);
            if (index < 0 || index >= _visitables.get("tasks").size()) { _visitables.get("tasks").add(builder); } else { _visitables.get("tasks").set(index, builder);}
            if (index < 0 || index >= tasks.size()) { tasks.add(builder); } else { tasks.set(index, builder);}
             return (A)this;
    }

    public A addToTasks(V1alpha1PipelineTemplateTask... items){
            if (this.tasks == null) {this.tasks = new ArrayList<V1alpha1PipelineTemplateTaskBuilder>();}
            for (V1alpha1PipelineTemplateTask item : items) {V1alpha1PipelineTemplateTaskBuilder builder = new V1alpha1PipelineTemplateTaskBuilder(item);_visitables.get("tasks").add(builder);this.tasks.add(builder);} return (A)this;
    }

    public A addAllToTasks(Collection<V1alpha1PipelineTemplateTask> items){
            if (this.tasks == null) {this.tasks = new ArrayList<V1alpha1PipelineTemplateTaskBuilder>();}
            for (V1alpha1PipelineTemplateTask item : items) {V1alpha1PipelineTemplateTaskBuilder builder = new V1alpha1PipelineTemplateTaskBuilder(item);_visitables.get("tasks").add(builder);this.tasks.add(builder);} return (A)this;
    }

    public A removeFromTasks(V1alpha1PipelineTemplateTask... items){
            for (V1alpha1PipelineTemplateTask item : items) {V1alpha1PipelineTemplateTaskBuilder builder = new V1alpha1PipelineTemplateTaskBuilder(item);_visitables.get("tasks").remove(builder);if (this.tasks != null) {this.tasks.remove(builder);}} return (A)this;
    }

    public A removeAllFromTasks(Collection<V1alpha1PipelineTemplateTask> items){
            for (V1alpha1PipelineTemplateTask item : items) {V1alpha1PipelineTemplateTaskBuilder builder = new V1alpha1PipelineTemplateTaskBuilder(item);_visitables.get("tasks").remove(builder);if (this.tasks != null) {this.tasks.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildTasks instead.
 * @return The buildable object.
 */
@Deprecated public List<V1alpha1PipelineTemplateTask> getTasks(){
            return build(tasks);
    }

    public List<V1alpha1PipelineTemplateTask> buildTasks(){
            return build(tasks);
    }

    public V1alpha1PipelineTemplateTask buildTask(int index){
            return this.tasks.get(index).build();
    }

    public V1alpha1PipelineTemplateTask buildFirstTask(){
            return this.tasks.get(0).build();
    }

    public V1alpha1PipelineTemplateTask buildLastTask(){
            return this.tasks.get(tasks.size() - 1).build();
    }

    public V1alpha1PipelineTemplateTask buildMatchingTask(io.alauda.devops.java.client.fluent.Predicate<V1alpha1PipelineTemplateTaskBuilder> predicate){
            for (V1alpha1PipelineTemplateTaskBuilder item: tasks) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public Boolean hasMatchingTask(io.alauda.devops.java.client.fluent.Predicate<V1alpha1PipelineTemplateTaskBuilder> predicate){
            for (V1alpha1PipelineTemplateTaskBuilder item: tasks) { if(predicate.apply(item)){return true;} } return false;
    }

    public A withTasks(List<V1alpha1PipelineTemplateTask> tasks){
            if (this.tasks != null) { _visitables.get("tasks").removeAll(this.tasks);}
            if (tasks != null) {this.tasks = new ArrayList<V1alpha1PipelineTemplateTaskBuilder>(); for (V1alpha1PipelineTemplateTask item : tasks){this.addToTasks(item);}} else { this.tasks = null;} return (A) this;
    }

    public A withTasks(V1alpha1PipelineTemplateTask... tasks){
            if (this.tasks != null) {this.tasks.clear();}
            if (tasks != null) {for (V1alpha1PipelineTemplateTask item :tasks){ this.addToTasks(item);}} return (A) this;
    }

    public Boolean hasTasks(){
            return tasks != null && !tasks.isEmpty();
    }

    public V1alpha1PipelineStageFluent.TasksNested<A> addNewTask(){
            return new TasksNestedImpl();
    }

    public V1alpha1PipelineStageFluent.TasksNested<A> addNewTaskLike(V1alpha1PipelineTemplateTask item){
            return new TasksNestedImpl(-1, item);
    }

    public V1alpha1PipelineStageFluent.TasksNested<A> setNewTaskLike(int index,V1alpha1PipelineTemplateTask item){
            return new TasksNestedImpl(index, item);
    }

    public V1alpha1PipelineStageFluent.TasksNested<A> editTask(int index){
            if (tasks.size() <= index) throw new RuntimeException("Can't edit tasks. Index exceeds size.");
            return setNewTaskLike(index, buildTask(index));
    }

    public V1alpha1PipelineStageFluent.TasksNested<A> editFirstTask(){
            if (tasks.size() == 0) throw new RuntimeException("Can't edit first tasks. The list is empty.");
            return setNewTaskLike(0, buildTask(0));
    }

    public V1alpha1PipelineStageFluent.TasksNested<A> editLastTask(){
            int index = tasks.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last tasks. The list is empty.");
            return setNewTaskLike(index, buildTask(index));
    }

    public V1alpha1PipelineStageFluent.TasksNested<A> editMatchingTask(io.alauda.devops.java.client.fluent.Predicate<V1alpha1PipelineTemplateTaskBuilder> predicate){
            int index = -1;
            for (int i=0;i<tasks.size();i++) { 
            if (predicate.apply(tasks.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching tasks. No match found.");
            return setNewTaskLike(index, buildTask(index));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1PipelineStageFluentImpl that = (V1alpha1PipelineStageFluentImpl) o;
            if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
            if (display != null ? !display.equals(that.display) :that.display != null) return false;
            if (name != null ? !name.equals(that.name) :that.name != null) return false;
            if (tasks != null ? !tasks.equals(that.tasks) :that.tasks != null) return false;
            return true;
    }


    public class DisplayNestedImpl<N> extends V1alpha1I18nNameFluentImpl<V1alpha1PipelineStageFluent.DisplayNested<N>> implements V1alpha1PipelineStageFluent.DisplayNested<N>,io.alauda.devops.java.client.fluent.Nested<N>{

            private final V1alpha1I18nNameBuilder builder;
    
            DisplayNestedImpl(V1alpha1I18nName item){
                    this.builder = new V1alpha1I18nNameBuilder(this, item);
            }
            DisplayNestedImpl(){
                    this.builder = new V1alpha1I18nNameBuilder(this);
            }
    
    public N and(){
            return (N) V1alpha1PipelineStageFluentImpl.this.withDisplay(builder.build());
    }
    public N endDisplay(){
            return and();
    }

}
    public class TasksNestedImpl<N> extends V1alpha1PipelineTemplateTaskFluentImpl<V1alpha1PipelineStageFluent.TasksNested<N>> implements V1alpha1PipelineStageFluent.TasksNested<N>,io.alauda.devops.java.client.fluent.Nested<N>{

            private final V1alpha1PipelineTemplateTaskBuilder builder;
        private final int index;
    
            TasksNestedImpl(int index,V1alpha1PipelineTemplateTask item){
                    this.index = index;
                    this.builder = new V1alpha1PipelineTemplateTaskBuilder(this, item);
            }
            TasksNestedImpl(){
                    this.index = -1;
                    this.builder = new V1alpha1PipelineTemplateTaskBuilder(this);
            }
    
    public N and(){
            return (N) V1alpha1PipelineStageFluentImpl.this.setToTasks(index, builder.build());
    }
    public N endTask(){
            return and();
    }

}


}
