package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1PipelineStageBuilder extends V1alpha1PipelineStageFluentImpl<V1alpha1PipelineStageBuilder> implements VisitableBuilder<V1alpha1PipelineStage,V1alpha1PipelineStageBuilder>{

    V1alpha1PipelineStageFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1PipelineStageBuilder(){
            this(true);
    }
    public V1alpha1PipelineStageBuilder(Boolean validationEnabled){
            this(new V1alpha1PipelineStage(), validationEnabled);
    }
    public V1alpha1PipelineStageBuilder(V1alpha1PipelineStageFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1PipelineStageBuilder(V1alpha1PipelineStageFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1PipelineStage(), validationEnabled);
    }
    public V1alpha1PipelineStageBuilder(V1alpha1PipelineStageFluent<?> fluent,V1alpha1PipelineStage instance){
            this(fluent, instance, true);
    }
    public V1alpha1PipelineStageBuilder(V1alpha1PipelineStageFluent<?> fluent,V1alpha1PipelineStage instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withConditions(instance.getConditions());

            fluent.withDisplay(instance.getDisplay());

            fluent.withName(instance.getName());

            fluent.withTasks(instance.getTasks());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1PipelineStageBuilder(V1alpha1PipelineStage instance){
            this(instance,true);
    }
    public V1alpha1PipelineStageBuilder(V1alpha1PipelineStage instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withConditions(instance.getConditions());

            this.withDisplay(instance.getDisplay());

            this.withName(instance.getName());

            this.withTasks(instance.getTasks());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1PipelineStage build(){
            V1alpha1PipelineStage buildable = new V1alpha1PipelineStage();
            buildable.setConditions(fluent.getConditions());
            buildable.setDisplay(fluent.getDisplay());
            buildable.setName(fluent.getName());
            buildable.setTasks(fluent.getTasks());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1PipelineStageBuilder that = (V1alpha1PipelineStageBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
