package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1ImageRepositoryStatusBuilder extends V1alpha1ImageRepositoryStatusFluentImpl<V1alpha1ImageRepositoryStatusBuilder> implements VisitableBuilder<V1alpha1ImageRepositoryStatus,V1alpha1ImageRepositoryStatusBuilder>{

    V1alpha1ImageRepositoryStatusFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1ImageRepositoryStatusBuilder(){
            this(true);
    }
    public V1alpha1ImageRepositoryStatusBuilder(Boolean validationEnabled){
            this(new V1alpha1ImageRepositoryStatus(), validationEnabled);
    }
    public V1alpha1ImageRepositoryStatusBuilder(V1alpha1ImageRepositoryStatusFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1ImageRepositoryStatusBuilder(V1alpha1ImageRepositoryStatusFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1ImageRepositoryStatus(), validationEnabled);
    }
    public V1alpha1ImageRepositoryStatusBuilder(V1alpha1ImageRepositoryStatusFluent<?> fluent,V1alpha1ImageRepositoryStatus instance){
            this(fluent, instance, true);
    }
    public V1alpha1ImageRepositoryStatusBuilder(V1alpha1ImageRepositoryStatusFluent<?> fluent,V1alpha1ImageRepositoryStatus instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withConditions(instance.getConditions());

            fluent.withHttp(instance.getHttp());

            fluent.withLastUpdated(instance.getLastUpdated());

            fluent.withLatestTag(instance.getLatestTag());

            fluent.withMessage(instance.getMessage());

            fluent.withPhase(instance.getPhase());

            fluent.withReason(instance.getReason());

            fluent.withTags(instance.getTags());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1ImageRepositoryStatusBuilder(V1alpha1ImageRepositoryStatus instance){
            this(instance,true);
    }
    public V1alpha1ImageRepositoryStatusBuilder(V1alpha1ImageRepositoryStatus instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withConditions(instance.getConditions());

            this.withHttp(instance.getHttp());

            this.withLastUpdated(instance.getLastUpdated());

            this.withLatestTag(instance.getLatestTag());

            this.withMessage(instance.getMessage());

            this.withPhase(instance.getPhase());

            this.withReason(instance.getReason());

            this.withTags(instance.getTags());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1ImageRepositoryStatus build(){
            V1alpha1ImageRepositoryStatus buildable = new V1alpha1ImageRepositoryStatus();
            buildable.setConditions(fluent.getConditions());
            buildable.setHttp(fluent.getHttp());
            buildable.setLastUpdated(fluent.getLastUpdated());
            buildable.setLatestTag(fluent.getLatestTag());
            buildable.setMessage(fluent.getMessage());
            buildable.setPhase(fluent.getPhase());
            buildable.setReason(fluent.getReason());
            buildable.setTags(fluent.getTags());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1ImageRepositoryStatusBuilder that = (V1alpha1ImageRepositoryStatusBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
