package io.alauda.devops.java.client.models;

import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.alauda.devops.java.client.fluent.Nested;
import java.lang.String;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.alauda.devops.java.client.fluent.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1ImageRepositorySpecFluentImpl<A extends V1alpha1ImageRepositorySpecFluent<A>> extends io.alauda.devops.java.client.fluent.BaseFluent<A> implements V1alpha1ImageRepositorySpecFluent<A>{

    private String image;
    private V1alpha1LocalObjectReferenceBuilder imageRegistry;
    private V1alpha1LocalObjectReferenceBuilder imageRegistryBinding;

    public V1alpha1ImageRepositorySpecFluentImpl(){
    }
    public V1alpha1ImageRepositorySpecFluentImpl(V1alpha1ImageRepositorySpec instance){
            this.withImage(instance.getImage());

            this.withImageRegistry(instance.getImageRegistry());

            this.withImageRegistryBinding(instance.getImageRegistryBinding());

    }

    public String getImage(){
            return this.image;
    }

    public A withImage(String image){
            this.image=image; return (A) this;
    }

    public Boolean hasImage(){
            return this.image != null;
    }

    public A withNewImage(String arg1){
            return (A)withImage(new String(arg1));
    }

    public A withNewImage(StringBuilder arg1){
            return (A)withImage(new String(arg1));
    }

    public A withNewImage(StringBuffer arg1){
            return (A)withImage(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildImageRegistry instead.
 * @return The buildable object.
 */
@Deprecated public V1alpha1LocalObjectReference getImageRegistry(){
            return this.imageRegistry!=null?this.imageRegistry.build():null;
    }

    public V1alpha1LocalObjectReference buildImageRegistry(){
            return this.imageRegistry!=null?this.imageRegistry.build():null;
    }

    public A withImageRegistry(V1alpha1LocalObjectReference imageRegistry){
            _visitables.get("imageRegistry").remove(this.imageRegistry);
            if (imageRegistry!=null){ this.imageRegistry= new V1alpha1LocalObjectReferenceBuilder(imageRegistry); _visitables.get("imageRegistry").add(this.imageRegistry);} return (A) this;
    }

    public Boolean hasImageRegistry(){
            return this.imageRegistry != null;
    }

    public V1alpha1ImageRepositorySpecFluent.ImageRegistryNested<A> withNewImageRegistry(){
            return new ImageRegistryNestedImpl();
    }

    public V1alpha1ImageRepositorySpecFluent.ImageRegistryNested<A> withNewImageRegistryLike(V1alpha1LocalObjectReference item){
            return new ImageRegistryNestedImpl(item);
    }

    public V1alpha1ImageRepositorySpecFluent.ImageRegistryNested<A> editImageRegistry(){
            return withNewImageRegistryLike(getImageRegistry());
    }

    public V1alpha1ImageRepositorySpecFluent.ImageRegistryNested<A> editOrNewImageRegistry(){
            return withNewImageRegistryLike(getImageRegistry() != null ? getImageRegistry(): new V1alpha1LocalObjectReferenceBuilder().build());
    }

    public V1alpha1ImageRepositorySpecFluent.ImageRegistryNested<A> editOrNewImageRegistryLike(V1alpha1LocalObjectReference item){
            return withNewImageRegistryLike(getImageRegistry() != null ? getImageRegistry(): item);
    }

    
/**
 * This method has been deprecated, please use method buildImageRegistryBinding instead.
 * @return The buildable object.
 */
@Deprecated public V1alpha1LocalObjectReference getImageRegistryBinding(){
            return this.imageRegistryBinding!=null?this.imageRegistryBinding.build():null;
    }

    public V1alpha1LocalObjectReference buildImageRegistryBinding(){
            return this.imageRegistryBinding!=null?this.imageRegistryBinding.build():null;
    }

    public A withImageRegistryBinding(V1alpha1LocalObjectReference imageRegistryBinding){
            _visitables.get("imageRegistryBinding").remove(this.imageRegistryBinding);
            if (imageRegistryBinding!=null){ this.imageRegistryBinding= new V1alpha1LocalObjectReferenceBuilder(imageRegistryBinding); _visitables.get("imageRegistryBinding").add(this.imageRegistryBinding);} return (A) this;
    }

    public Boolean hasImageRegistryBinding(){
            return this.imageRegistryBinding != null;
    }

    public V1alpha1ImageRepositorySpecFluent.ImageRegistryBindingNested<A> withNewImageRegistryBinding(){
            return new ImageRegistryBindingNestedImpl();
    }

    public V1alpha1ImageRepositorySpecFluent.ImageRegistryBindingNested<A> withNewImageRegistryBindingLike(V1alpha1LocalObjectReference item){
            return new ImageRegistryBindingNestedImpl(item);
    }

    public V1alpha1ImageRepositorySpecFluent.ImageRegistryBindingNested<A> editImageRegistryBinding(){
            return withNewImageRegistryBindingLike(getImageRegistryBinding());
    }

    public V1alpha1ImageRepositorySpecFluent.ImageRegistryBindingNested<A> editOrNewImageRegistryBinding(){
            return withNewImageRegistryBindingLike(getImageRegistryBinding() != null ? getImageRegistryBinding(): new V1alpha1LocalObjectReferenceBuilder().build());
    }

    public V1alpha1ImageRepositorySpecFluent.ImageRegistryBindingNested<A> editOrNewImageRegistryBindingLike(V1alpha1LocalObjectReference item){
            return withNewImageRegistryBindingLike(getImageRegistryBinding() != null ? getImageRegistryBinding(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1ImageRepositorySpecFluentImpl that = (V1alpha1ImageRepositorySpecFluentImpl) o;
            if (image != null ? !image.equals(that.image) :that.image != null) return false;
            if (imageRegistry != null ? !imageRegistry.equals(that.imageRegistry) :that.imageRegistry != null) return false;
            if (imageRegistryBinding != null ? !imageRegistryBinding.equals(that.imageRegistryBinding) :that.imageRegistryBinding != null) return false;
            return true;
    }


    public class ImageRegistryNestedImpl<N> extends V1alpha1LocalObjectReferenceFluentImpl<V1alpha1ImageRepositorySpecFluent.ImageRegistryNested<N>> implements V1alpha1ImageRepositorySpecFluent.ImageRegistryNested<N>,io.alauda.devops.java.client.fluent.Nested<N>{

            private final V1alpha1LocalObjectReferenceBuilder builder;
    
            ImageRegistryNestedImpl(V1alpha1LocalObjectReference item){
                    this.builder = new V1alpha1LocalObjectReferenceBuilder(this, item);
            }
            ImageRegistryNestedImpl(){
                    this.builder = new V1alpha1LocalObjectReferenceBuilder(this);
            }
    
    public N and(){
            return (N) V1alpha1ImageRepositorySpecFluentImpl.this.withImageRegistry(builder.build());
    }
    public N endImageRegistry(){
            return and();
    }

}
    public class ImageRegistryBindingNestedImpl<N> extends V1alpha1LocalObjectReferenceFluentImpl<V1alpha1ImageRepositorySpecFluent.ImageRegistryBindingNested<N>> implements V1alpha1ImageRepositorySpecFluent.ImageRegistryBindingNested<N>,io.alauda.devops.java.client.fluent.Nested<N>{

            private final V1alpha1LocalObjectReferenceBuilder builder;
    
            ImageRegistryBindingNestedImpl(V1alpha1LocalObjectReference item){
                    this.builder = new V1alpha1LocalObjectReferenceBuilder(this, item);
            }
            ImageRegistryBindingNestedImpl(){
                    this.builder = new V1alpha1LocalObjectReferenceBuilder(this);
            }
    
    public N and(){
            return (N) V1alpha1ImageRepositorySpecFluentImpl.this.withImageRegistryBinding(builder.build());
    }
    public N endImageRegistryBinding(){
            return and();
    }

}


}
