package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1ImageRegistryBindingTemplateBuilder extends V1alpha1ImageRegistryBindingTemplateFluentImpl<V1alpha1ImageRegistryBindingTemplateBuilder> implements VisitableBuilder<V1alpha1ImageRegistryBindingTemplate,V1alpha1ImageRegistryBindingTemplateBuilder>{

    V1alpha1ImageRegistryBindingTemplateFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1ImageRegistryBindingTemplateBuilder(){
            this(true);
    }
    public V1alpha1ImageRegistryBindingTemplateBuilder(Boolean validationEnabled){
            this(new V1alpha1ImageRegistryBindingTemplate(), validationEnabled);
    }
    public V1alpha1ImageRegistryBindingTemplateBuilder(V1alpha1ImageRegistryBindingTemplateFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1ImageRegistryBindingTemplateBuilder(V1alpha1ImageRegistryBindingTemplateFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1ImageRegistryBindingTemplate(), validationEnabled);
    }
    public V1alpha1ImageRegistryBindingTemplateBuilder(V1alpha1ImageRegistryBindingTemplateFluent<?> fluent,V1alpha1ImageRegistryBindingTemplate instance){
            this(fluent, instance, true);
    }
    public V1alpha1ImageRegistryBindingTemplateBuilder(V1alpha1ImageRegistryBindingTemplateFluent<?> fluent,V1alpha1ImageRegistryBindingTemplate instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withSelector(instance.getSelector());

            fluent.withSpec(instance.getSpec());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1ImageRegistryBindingTemplateBuilder(V1alpha1ImageRegistryBindingTemplate instance){
            this(instance,true);
    }
    public V1alpha1ImageRegistryBindingTemplateBuilder(V1alpha1ImageRegistryBindingTemplate instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withSelector(instance.getSelector());

            this.withSpec(instance.getSpec());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1ImageRegistryBindingTemplate build(){
            V1alpha1ImageRegistryBindingTemplate buildable = new V1alpha1ImageRegistryBindingTemplate();
            buildable.setSelector(fluent.getSelector());
            buildable.setSpec(fluent.getSpec());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1ImageRegistryBindingTemplateBuilder that = (V1alpha1ImageRegistryBindingTemplateBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
