package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1CodeRepositoryInfoBuilder extends V1alpha1CodeRepositoryInfoFluentImpl<V1alpha1CodeRepositoryInfoBuilder> implements VisitableBuilder<V1alpha1CodeRepositoryInfo,V1alpha1CodeRepositoryInfoBuilder>{

    V1alpha1CodeRepositoryInfoFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1CodeRepositoryInfoBuilder(){
            this(true);
    }
    public V1alpha1CodeRepositoryInfoBuilder(Boolean validationEnabled){
            this(new V1alpha1CodeRepositoryInfo(), validationEnabled);
    }
    public V1alpha1CodeRepositoryInfoBuilder(V1alpha1CodeRepositoryInfoFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1CodeRepositoryInfoBuilder(V1alpha1CodeRepositoryInfoFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1CodeRepositoryInfo(), validationEnabled);
    }
    public V1alpha1CodeRepositoryInfoBuilder(V1alpha1CodeRepositoryInfoFluent<?> fluent,V1alpha1CodeRepositoryInfo instance){
            this(fluent, instance, true);
    }
    public V1alpha1CodeRepositoryInfoBuilder(V1alpha1CodeRepositoryInfoFluent<?> fluent,V1alpha1CodeRepositoryInfo instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAll(instance.isAll());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1CodeRepositoryInfoBuilder(V1alpha1CodeRepositoryInfo instance){
            this(instance,true);
    }
    public V1alpha1CodeRepositoryInfoBuilder(V1alpha1CodeRepositoryInfo instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAll(instance.isAll());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1CodeRepositoryInfo build(){
            V1alpha1CodeRepositoryInfo buildable = new V1alpha1CodeRepositoryInfo();
            buildable.setAll(fluent.isAll());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1CodeRepositoryInfoBuilder that = (V1alpha1CodeRepositoryInfoBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
