package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1CodeRepoBindingSpecBuilder extends V1alpha1CodeRepoBindingSpecFluentImpl<V1alpha1CodeRepoBindingSpecBuilder> implements VisitableBuilder<V1alpha1CodeRepoBindingSpec,V1alpha1CodeRepoBindingSpecBuilder>{

    V1alpha1CodeRepoBindingSpecFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1CodeRepoBindingSpecBuilder(){
            this(true);
    }
    public V1alpha1CodeRepoBindingSpecBuilder(Boolean validationEnabled){
            this(new V1alpha1CodeRepoBindingSpec(), validationEnabled);
    }
    public V1alpha1CodeRepoBindingSpecBuilder(V1alpha1CodeRepoBindingSpecFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1CodeRepoBindingSpecBuilder(V1alpha1CodeRepoBindingSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1CodeRepoBindingSpec(), validationEnabled);
    }
    public V1alpha1CodeRepoBindingSpecBuilder(V1alpha1CodeRepoBindingSpecFluent<?> fluent,V1alpha1CodeRepoBindingSpec instance){
            this(fluent, instance, true);
    }
    public V1alpha1CodeRepoBindingSpecBuilder(V1alpha1CodeRepoBindingSpecFluent<?> fluent,V1alpha1CodeRepoBindingSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAccount(instance.getAccount());

            fluent.withCodeRepoService(instance.getCodeRepoService());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1CodeRepoBindingSpecBuilder(V1alpha1CodeRepoBindingSpec instance){
            this(instance,true);
    }
    public V1alpha1CodeRepoBindingSpecBuilder(V1alpha1CodeRepoBindingSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAccount(instance.getAccount());

            this.withCodeRepoService(instance.getCodeRepoService());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1CodeRepoBindingSpec build(){
            V1alpha1CodeRepoBindingSpec buildable = new V1alpha1CodeRepoBindingSpec();
            buildable.setAccount(fluent.getAccount());
            buildable.setCodeRepoService(fluent.getCodeRepoService());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1CodeRepoBindingSpecBuilder that = (V1alpha1CodeRepoBindingSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
