package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1CodeQualityConditionBuilder extends V1alpha1CodeQualityConditionFluentImpl<V1alpha1CodeQualityConditionBuilder> implements VisitableBuilder<V1alpha1CodeQualityCondition,V1alpha1CodeQualityConditionBuilder>{

    V1alpha1CodeQualityConditionFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1CodeQualityConditionBuilder(){
            this(true);
    }
    public V1alpha1CodeQualityConditionBuilder(Boolean validationEnabled){
            this(new V1alpha1CodeQualityCondition(), validationEnabled);
    }
    public V1alpha1CodeQualityConditionBuilder(V1alpha1CodeQualityConditionFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1CodeQualityConditionBuilder(V1alpha1CodeQualityConditionFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1CodeQualityCondition(), validationEnabled);
    }
    public V1alpha1CodeQualityConditionBuilder(V1alpha1CodeQualityConditionFluent<?> fluent,V1alpha1CodeQualityCondition instance){
            this(fluent, instance, true);
    }
    public V1alpha1CodeQualityConditionBuilder(V1alpha1CodeQualityConditionFluent<?> fluent,V1alpha1CodeQualityCondition instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withBindingCondition(instance.getBindingCondition());

            fluent.withBranch(instance.getBranch());

            fluent.withIsMain(instance.isIsMain());

            fluent.withMetrics(instance.getMetrics());

            fluent.withQualityGate(instance.getQualityGate());

            fluent.withVisibility(instance.getVisibility());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1CodeQualityConditionBuilder(V1alpha1CodeQualityCondition instance){
            this(instance,true);
    }
    public V1alpha1CodeQualityConditionBuilder(V1alpha1CodeQualityCondition instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withBindingCondition(instance.getBindingCondition());

            this.withBranch(instance.getBranch());

            this.withIsMain(instance.isIsMain());

            this.withMetrics(instance.getMetrics());

            this.withQualityGate(instance.getQualityGate());

            this.withVisibility(instance.getVisibility());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1CodeQualityCondition build(){
            V1alpha1CodeQualityCondition buildable = new V1alpha1CodeQualityCondition();
            buildable.setBindingCondition(fluent.getBindingCondition());
            buildable.setBranch(fluent.getBranch());
            buildable.setIsMain(fluent.isIsMain());
            buildable.setMetrics(fluent.getMetrics());
            buildable.setQualityGate(fluent.getQualityGate());
            buildable.setVisibility(fluent.getVisibility());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1CodeQualityConditionBuilder that = (V1alpha1CodeQualityConditionBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
