package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1CodeQualityBindingBuilder extends V1alpha1CodeQualityBindingFluentImpl<V1alpha1CodeQualityBindingBuilder> implements VisitableBuilder<V1alpha1CodeQualityBinding,V1alpha1CodeQualityBindingBuilder>{

    V1alpha1CodeQualityBindingFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1CodeQualityBindingBuilder(){
            this(true);
    }
    public V1alpha1CodeQualityBindingBuilder(Boolean validationEnabled){
            this(new V1alpha1CodeQualityBinding(), validationEnabled);
    }
    public V1alpha1CodeQualityBindingBuilder(V1alpha1CodeQualityBindingFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1CodeQualityBindingBuilder(V1alpha1CodeQualityBindingFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1CodeQualityBinding(), validationEnabled);
    }
    public V1alpha1CodeQualityBindingBuilder(V1alpha1CodeQualityBindingFluent<?> fluent,V1alpha1CodeQualityBinding instance){
            this(fluent, instance, true);
    }
    public V1alpha1CodeQualityBindingBuilder(V1alpha1CodeQualityBindingFluent<?> fluent,V1alpha1CodeQualityBinding instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion());

            fluent.withKind(instance.getKind());

            fluent.withMetadata(instance.getMetadata());

            fluent.withSpec(instance.getSpec());

            fluent.withStatus(instance.getStatus());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1CodeQualityBindingBuilder(V1alpha1CodeQualityBinding instance){
            this(instance,true);
    }
    public V1alpha1CodeQualityBindingBuilder(V1alpha1CodeQualityBinding instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion());

            this.withKind(instance.getKind());

            this.withMetadata(instance.getMetadata());

            this.withSpec(instance.getSpec());

            this.withStatus(instance.getStatus());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1CodeQualityBinding build(){
            V1alpha1CodeQualityBinding buildable = new V1alpha1CodeQualityBinding();
            buildable.setApiVersion(fluent.getApiVersion());
            buildable.setKind(fluent.getKind());
            buildable.setMetadata(fluent.getMetadata());
            buildable.setSpec(fluent.getSpec());
            buildable.setStatus(fluent.getStatus());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1CodeQualityBindingBuilder that = (V1alpha1CodeQualityBindingBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
