package io.alauda.devops.java.client.models;

import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.models.V1LabelSelectorRequirement;
import java.util.ArrayList;
import java.lang.String;
import io.alauda.devops.java.client.fluent.Predicate;
import java.util.LinkedHashMap;
import java.lang.StringBuffer;
import io.alauda.devops.java.client.fluent.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public class V1alpha1BindingReplicaNamespaceSelectorFluentImpl<A extends V1alpha1BindingReplicaNamespaceSelectorFluent<A>> extends io.alauda.devops.java.client.fluent.BaseFluent<A> implements V1alpha1BindingReplicaNamespaceSelectorFluent<A>{

    private List<V1LabelSelectorRequirement> matchExpressions;
    private Map<String,String> matchLabels;
    private List<String> namespaces;

    public V1alpha1BindingReplicaNamespaceSelectorFluentImpl(){
    }
    public V1alpha1BindingReplicaNamespaceSelectorFluentImpl(V1alpha1BindingReplicaNamespaceSelector instance){
            this.withMatchExpressions(instance.getMatchExpressions());

            this.withMatchLabels(instance.getMatchLabels());

            this.withNamespaces(instance.getNamespaces());

    }

    public A addToMatchExpressions(int index,V1LabelSelectorRequirement item){
            if (this.matchExpressions == null) {this.matchExpressions = new ArrayList<V1LabelSelectorRequirement>();}
            this.matchExpressions.add(index, item);
            return (A)this;
    }

    public A setToMatchExpressions(int index,V1LabelSelectorRequirement item){
            if (this.matchExpressions == null) {this.matchExpressions = new ArrayList<V1LabelSelectorRequirement>();}
            this.matchExpressions.set(index, item); return (A)this;
    }

    public A addToMatchExpressions(V1LabelSelectorRequirement... items){
            if (this.matchExpressions == null) {this.matchExpressions = new ArrayList<V1LabelSelectorRequirement>();}
            for (V1LabelSelectorRequirement item : items) {this.matchExpressions.add(item);} return (A)this;
    }

    public A addAllToMatchExpressions(Collection<V1LabelSelectorRequirement> items){
            if (this.matchExpressions == null) {this.matchExpressions = new ArrayList<V1LabelSelectorRequirement>();}
            for (V1LabelSelectorRequirement item : items) {this.matchExpressions.add(item);} return (A)this;
    }

    public A removeFromMatchExpressions(V1LabelSelectorRequirement... items){
            for (V1LabelSelectorRequirement item : items) {if (this.matchExpressions!= null){ this.matchExpressions.remove(item);}} return (A)this;
    }

    public A removeAllFromMatchExpressions(Collection<V1LabelSelectorRequirement> items){
            for (V1LabelSelectorRequirement item : items) {if (this.matchExpressions!= null){ this.matchExpressions.remove(item);}} return (A)this;
    }

    public List<V1LabelSelectorRequirement> getMatchExpressions(){
            return this.matchExpressions;
    }

    public V1LabelSelectorRequirement getMatchExpression(int index){
            return this.matchExpressions.get(index);
    }

    public V1LabelSelectorRequirement getFirstMatchExpression(){
            return this.matchExpressions.get(0);
    }

    public V1LabelSelectorRequirement getLastMatchExpression(){
            return this.matchExpressions.get(matchExpressions.size() - 1);
    }

    public V1LabelSelectorRequirement getMatchingMatchExpression(io.alauda.devops.java.client.fluent.Predicate<V1LabelSelectorRequirement> predicate){
            for (V1LabelSelectorRequirement item: matchExpressions) { if(predicate.apply(item)){return item;} } return null;
    }

    public Boolean hasMatchingMatchExpression(io.alauda.devops.java.client.fluent.Predicate<V1LabelSelectorRequirement> predicate){
            for (V1LabelSelectorRequirement item: matchExpressions) { if(predicate.apply(item)){return true;} } return false;
    }

    public A withMatchExpressions(List<V1LabelSelectorRequirement> matchExpressions){
            if (this.matchExpressions != null) { _visitables.get("matchExpressions").removeAll(this.matchExpressions);}
            if (matchExpressions != null) {this.matchExpressions = new ArrayList<V1LabelSelectorRequirement>(); for (V1LabelSelectorRequirement item : matchExpressions){this.addToMatchExpressions(item);}} else { this.matchExpressions = null;} return (A) this;
    }

    public A withMatchExpressions(V1LabelSelectorRequirement... matchExpressions){
            if (this.matchExpressions != null) {this.matchExpressions.clear();}
            if (matchExpressions != null) {for (V1LabelSelectorRequirement item :matchExpressions){ this.addToMatchExpressions(item);}} return (A) this;
    }

    public Boolean hasMatchExpressions(){
            return matchExpressions != null && !matchExpressions.isEmpty();
    }

    public A addToMatchLabels(String key,String value){
            if(this.matchLabels == null && key != null && value != null) { this.matchLabels = new LinkedHashMap<String,String>(); }
            if(key != null && value != null) {this.matchLabels.put(key, value);} return (A)this;
    }

    public A addToMatchLabels(Map<String,String> map){
            if(this.matchLabels == null && map != null) { this.matchLabels = new LinkedHashMap<String,String>(); }
            if(map != null) { this.matchLabels.putAll(map);} return (A)this;
    }

    public A removeFromMatchLabels(String key){
            if(this.matchLabels == null) { return (A) this; }
            if(key != null && this.matchLabels != null) {this.matchLabels.remove(key);} return (A)this;
    }

    public A removeFromMatchLabels(Map<String,String> map){
            if(this.matchLabels == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.matchLabels != null){this.matchLabels.remove(key);}}} return (A)this;
    }

    public Map<String,String> getMatchLabels(){
            return this.matchLabels;
    }

    public A withMatchLabels(Map<String,String> matchLabels){
            if (matchLabels == null) { this.matchLabels =  null;} else {this.matchLabels = new LinkedHashMap<String,String>(matchLabels);} return (A) this;
    }

    public Boolean hasMatchLabels(){
            return this.matchLabels != null;
    }

    public A addToNamespaces(int index,String item){
            if (this.namespaces == null) {this.namespaces = new ArrayList<String>();}
            this.namespaces.add(index, item);
            return (A)this;
    }

    public A setToNamespaces(int index,String item){
            if (this.namespaces == null) {this.namespaces = new ArrayList<String>();}
            this.namespaces.set(index, item); return (A)this;
    }

    public A addToNamespaces(String... items){
            if (this.namespaces == null) {this.namespaces = new ArrayList<String>();}
            for (String item : items) {this.namespaces.add(item);} return (A)this;
    }

    public A addAllToNamespaces(Collection<String> items){
            if (this.namespaces == null) {this.namespaces = new ArrayList<String>();}
            for (String item : items) {this.namespaces.add(item);} return (A)this;
    }

    public A removeFromNamespaces(String... items){
            for (String item : items) {if (this.namespaces!= null){ this.namespaces.remove(item);}} return (A)this;
    }

    public A removeAllFromNamespaces(Collection<String> items){
            for (String item : items) {if (this.namespaces!= null){ this.namespaces.remove(item);}} return (A)this;
    }

    public List<String> getNamespaces(){
            return this.namespaces;
    }

    public String getNamespace(int index){
            return this.namespaces.get(index);
    }

    public String getFirstNamespace(){
            return this.namespaces.get(0);
    }

    public String getLastNamespace(){
            return this.namespaces.get(namespaces.size() - 1);
    }

    public String getMatchingNamespace(io.alauda.devops.java.client.fluent.Predicate<String> predicate){
            for (String item: namespaces) { if(predicate.apply(item)){return item;} } return null;
    }

    public Boolean hasMatchingNamespace(io.alauda.devops.java.client.fluent.Predicate<String> predicate){
            for (String item: namespaces) { if(predicate.apply(item)){return true;} } return false;
    }

    public A withNamespaces(List<String> namespaces){
            if (this.namespaces != null) { _visitables.get("namespaces").removeAll(this.namespaces);}
            if (namespaces != null) {this.namespaces = new ArrayList<String>(); for (String item : namespaces){this.addToNamespaces(item);}} else { this.namespaces = null;} return (A) this;
    }

    public A withNamespaces(String... namespaces){
            if (this.namespaces != null) {this.namespaces.clear();}
            if (namespaces != null) {for (String item :namespaces){ this.addToNamespaces(item);}} return (A) this;
    }

    public Boolean hasNamespaces(){
            return namespaces != null && !namespaces.isEmpty();
    }

    public A addNewNamespace(String arg1){
            return (A)addToNamespaces(new String(arg1));
    }

    public A addNewNamespace(StringBuilder arg1){
            return (A)addToNamespaces(new String(arg1));
    }

    public A addNewNamespace(StringBuffer arg1){
            return (A)addToNamespaces(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1BindingReplicaNamespaceSelectorFluentImpl that = (V1alpha1BindingReplicaNamespaceSelectorFluentImpl) o;
            if (matchExpressions != null ? !matchExpressions.equals(that.matchExpressions) :that.matchExpressions != null) return false;
            if (matchLabels != null ? !matchLabels.equals(that.matchLabels) :that.matchLabels != null) return false;
            if (namespaces != null ? !namespaces.equals(that.namespaces) :that.namespaces != null) return false;
            return true;
    }




}
